/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.repository_analyze;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class WriteSummaryInfo
implements JsonpSerializable {
    private final int count;
    private final Time totalElapsed;
    private final long totalElapsedNanos;
    private final String totalSize;
    private final long totalSizeBytes;
    private final Time totalThrottled;
    private final long totalThrottledNanos;
    public static final JsonpDeserializer<WriteSummaryInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WriteSummaryInfo::setupWriteSummaryInfoDeserializer);

    private WriteSummaryInfo(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0);
        this.totalElapsed = ApiTypeHelper.requireNonNull(builder.totalElapsed, this, "totalElapsed");
        this.totalElapsedNanos = ApiTypeHelper.requireNonNull(builder.totalElapsedNanos, (Object)this, "totalElapsedNanos", 0L);
        this.totalSize = ApiTypeHelper.requireNonNull(builder.totalSize, this, "totalSize");
        this.totalSizeBytes = ApiTypeHelper.requireNonNull(builder.totalSizeBytes, (Object)this, "totalSizeBytes", 0L);
        this.totalThrottled = ApiTypeHelper.requireNonNull(builder.totalThrottled, this, "totalThrottled");
        this.totalThrottledNanos = ApiTypeHelper.requireNonNull(builder.totalThrottledNanos, (Object)this, "totalThrottledNanos", 0L);
    }

    public static WriteSummaryInfo of(Function<Builder, ObjectBuilder<WriteSummaryInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    public final Time totalElapsed() {
        return this.totalElapsed;
    }

    public final long totalElapsedNanos() {
        return this.totalElapsedNanos;
    }

    public final String totalSize() {
        return this.totalSize;
    }

    public final long totalSizeBytes() {
        return this.totalSizeBytes;
    }

    public final Time totalThrottled() {
        return this.totalThrottled;
    }

    public final long totalThrottledNanos() {
        return this.totalThrottledNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("total_elapsed");
        this.totalElapsed.serialize(generator, mapper);
        generator.writeKey("total_elapsed_nanos");
        generator.write(this.totalElapsedNanos);
        generator.writeKey("total_size");
        generator.write(this.totalSize);
        generator.writeKey("total_size_bytes");
        generator.write(this.totalSizeBytes);
        generator.writeKey("total_throttled");
        this.totalThrottled.serialize(generator, mapper);
        generator.writeKey("total_throttled_nanos");
        generator.write(this.totalThrottledNanos);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWriteSummaryInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::totalElapsed, Time._DESERIALIZER, "total_elapsed");
        op.add(Builder::totalElapsedNanos, JsonpDeserializer.longDeserializer(), "total_elapsed_nanos");
        op.add(Builder::totalSize, JsonpDeserializer.stringDeserializer(), "total_size");
        op.add(Builder::totalSizeBytes, JsonpDeserializer.longDeserializer(), "total_size_bytes");
        op.add(Builder::totalThrottled, Time._DESERIALIZER, "total_throttled");
        op.add(Builder::totalThrottledNanos, JsonpDeserializer.longDeserializer(), "total_throttled_nanos");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WriteSummaryInfo> {
        private Integer count;
        private Time totalElapsed;
        private Long totalElapsedNanos;
        private String totalSize;
        private Long totalSizeBytes;
        private Time totalThrottled;
        private Long totalThrottledNanos;

        public Builder() {
        }

        private Builder(WriteSummaryInfo instance) {
            this.count = instance.count;
            this.totalElapsed = instance.totalElapsed;
            this.totalElapsedNanos = instance.totalElapsedNanos;
            this.totalSize = instance.totalSize;
            this.totalSizeBytes = instance.totalSizeBytes;
            this.totalThrottled = instance.totalThrottled;
            this.totalThrottledNanos = instance.totalThrottledNanos;
        }

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder totalElapsed(Time value) {
            this.totalElapsed = value;
            return this;
        }

        public final Builder totalElapsed(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalElapsed(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalElapsedNanos(long value) {
            this.totalElapsedNanos = value;
            return this;
        }

        public final Builder totalSize(String value) {
            this.totalSize = value;
            return this;
        }

        public final Builder totalSizeBytes(long value) {
            this.totalSizeBytes = value;
            return this;
        }

        public final Builder totalThrottled(Time value) {
            this.totalThrottled = value;
            return this;
        }

        public final Builder totalThrottled(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.totalThrottled(fn.apply(new Time.Builder()).build());
        }

        public final Builder totalThrottledNanos(long value) {
            this.totalThrottledNanos = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WriteSummaryInfo build() {
            this._checkSingleUse();
            return new WriteSummaryInfo(this);
        }
    }
}

