/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.GcsRepositorySettings;
import co.elastic.clients.elasticsearch.snapshot.Repository;
import co.elastic.clients.elasticsearch.snapshot.RepositoryBase;
import co.elastic.clients.elasticsearch.snapshot.RepositoryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GcsRepository
extends RepositoryBase
implements RepositoryVariant {
    private final GcsRepositorySettings settings;
    public static final JsonpDeserializer<GcsRepository> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GcsRepository::setupGcsRepositoryDeserializer);

    private GcsRepository(Builder builder) {
        super(builder);
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
    }

    public static GcsRepository of(Function<Builder, ObjectBuilder<GcsRepository>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Repository.Kind _repositoryKind() {
        return Repository.Kind.Gcs;
    }

    public final GcsRepositorySettings settings() {
        return this.settings;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "gcs");
        super.serializeInternal(generator, mapper);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGcsRepositoryDeserializer(ObjectDeserializer<Builder> op) {
        RepositoryBase.setupRepositoryBaseDeserializer(op);
        op.add(Builder::settings, GcsRepositorySettings._DESERIALIZER, "settings");
        op.ignore("type");
    }

    public static class Builder
    extends RepositoryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GcsRepository> {
        private GcsRepositorySettings settings;

        public Builder() {
        }

        private Builder(GcsRepository instance) {
            this.settings = instance.settings;
        }

        public final Builder settings(GcsRepositorySettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<GcsRepositorySettings.Builder, ObjectBuilder<GcsRepositorySettings>> fn) {
            return this.settings(fn.apply(new GcsRepositorySettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GcsRepository build() {
            this._checkSingleUse();
            return new GcsRepository(this);
        }
    }
}

