/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.CloneSnapshotResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CloneSnapshotRequest
extends RequestBase
implements JsonpSerializable {
    private final String indices;
    @Nullable
    private final Time masterTimeout;
    private final String repository;
    private final String snapshot;
    private final String targetSnapshot;
    public static final JsonpDeserializer<CloneSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CloneSnapshotRequest::setupCloneSnapshotRequestDeserializer);
    public static final Endpoint<CloneSnapshotRequest, CloneSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CloneSnapshotRequest, CloneSnapshotResponse>("es/snapshot.clone", request -> "PUT", request -> {
        boolean _targetSnapshot = true;
        int _repository = 2;
        int _snapshot = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot, buf);
            buf.append("/_clone");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.targetSnapshot, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _targetSnapshot = true;
        int _repository = 2;
        int _snapshot = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if ((propsSet |= 4) == 7) {
            params.put("repository", request.repository);
            params.put("snapshot", request.snapshot);
            params.put("targetSnapshot", request.targetSnapshot);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, CloneSnapshotResponse._DESERIALIZER);

    private CloneSnapshotRequest(Builder builder) {
        this.indices = ApiTypeHelper.requireNonNull(builder.indices, this, "indices");
        this.masterTimeout = builder.masterTimeout;
        this.repository = ApiTypeHelper.requireNonNull(builder.repository, this, "repository");
        this.snapshot = ApiTypeHelper.requireNonNull(builder.snapshot, this, "snapshot");
        this.targetSnapshot = ApiTypeHelper.requireNonNull(builder.targetSnapshot, this, "targetSnapshot");
    }

    public static CloneSnapshotRequest of(Function<Builder, ObjectBuilder<CloneSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String indices() {
        return this.indices;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String repository() {
        return this.repository;
    }

    public final String snapshot() {
        return this.snapshot;
    }

    public final String targetSnapshot() {
        return this.targetSnapshot;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("indices");
        generator.write(this.indices);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCloneSnapshotRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::indices, JsonpDeserializer.stringDeserializer(), "indices");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CloneSnapshotRequest> {
        private String indices;
        @Nullable
        private Time masterTimeout;
        private String repository;
        private String snapshot;
        private String targetSnapshot;

        public Builder() {
        }

        private Builder(CloneSnapshotRequest instance) {
            this.indices = instance.indices;
            this.masterTimeout = instance.masterTimeout;
            this.repository = instance.repository;
            this.snapshot = instance.snapshot;
            this.targetSnapshot = instance.targetSnapshot;
        }

        public final Builder indices(String value) {
            this.indices = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder repository(String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public final Builder targetSnapshot(String value) {
            this.targetSnapshot = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CloneSnapshotRequest build() {
            this._checkSingleUse();
            return new CloneSnapshotRequest(this);
        }
    }
}

