/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.slm.DeleteLifecycleResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteLifecycleRequest
extends RequestBase {
    @Nullable
    private final Time masterTimeout;
    private final String policyId;
    @Nullable
    private final Time timeout;
    public static final Endpoint<DeleteLifecycleRequest, DeleteLifecycleResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteLifecycleRequest, DeleteLifecycleResponse>("es/slm.delete_lifecycle", request -> "DELETE", request -> {
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_slm");
            buf.append("/policy");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.policyId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _policyId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("policyId", request.policyId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteLifecycleResponse._DESERIALIZER);

    private DeleteLifecycleRequest(Builder builder) {
        this.masterTimeout = builder.masterTimeout;
        this.policyId = ApiTypeHelper.requireNonNull(builder.policyId, this, "policyId");
        this.timeout = builder.timeout;
    }

    public static DeleteLifecycleRequest of(Function<Builder, ObjectBuilder<DeleteLifecycleRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final String policyId() {
        return this.policyId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteLifecycleRequest> {
        @Nullable
        private Time masterTimeout;
        private String policyId;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(DeleteLifecycleRequest instance) {
            this.masterTimeout = instance.masterTimeout;
            this.policyId = instance.policyId;
            this.timeout = instance.timeout;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder policyId(String value) {
            this.policyId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteLifecycleRequest build() {
            this._checkSingleUse();
            return new DeleteLifecycleRequest(this);
        }
    }
}

