/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.has_privileges;

import co.elastic.clients.elasticsearch.security.IndexPrivilege;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndexPrivilegesCheck
implements JsonpSerializable {
    private final List<String> names;
    private final List<String> privileges;
    @Nullable
    private final Boolean allowRestrictedIndices;
    public static final JsonpDeserializer<IndexPrivilegesCheck> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexPrivilegesCheck::setupIndexPrivilegesCheckDeserializer);

    private IndexPrivilegesCheck(Builder builder) {
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
        this.allowRestrictedIndices = builder.allowRestrictedIndices;
    }

    public static IndexPrivilegesCheck of(Function<Builder, ObjectBuilder<IndexPrivilegesCheck>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> names() {
        return this.names;
    }

    public final List<String> privileges() {
        return this.privileges;
    }

    @Nullable
    public final Boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String item0 : this.names) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (String item0 : this.privileges) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.allowRestrictedIndices != null) {
            generator.writeKey("allow_restricted_indices");
            generator.write(this.allowRestrictedIndices.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIndexPrivilegesCheckDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "privileges");
        op.add(Builder::allowRestrictedIndices, JsonpDeserializer.booleanDeserializer(), "allow_restricted_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndexPrivilegesCheck> {
        private List<String> names;
        private List<String> privileges;
        @Nullable
        private Boolean allowRestrictedIndices;

        public Builder() {
        }

        private Builder(IndexPrivilegesCheck instance) {
            this.names = instance.names;
            this.privileges = instance.privileges;
            this.allowRestrictedIndices = instance.allowRestrictedIndices;
        }

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder privileges(List<String> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(String value, String ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        public final Builder privileges(IndexPrivilege value, IndexPrivilege ... values) {
            this.privileges = Builder._listAdd(this.privileges, value.jsonValue(), (String[])Arrays.stream(values).map(IndexPrivilege::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder allowRestrictedIndices(@Nullable Boolean value) {
            this.allowRestrictedIndices = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndexPrivilegesCheck build() {
            this._checkSingleUse();
            return new IndexPrivilegesCheck(this);
        }
    }
}

