/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch.security.FieldSecurity;
import co.elastic.clients.elasticsearch.security.IndexPrivilege;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UserIndicesPrivileges
implements JsonpSerializable {
    private final List<FieldSecurity> fieldSecurity;
    private final List<String> names;
    private final List<String> privileges;
    private final List<Query> query;
    private final boolean allowRestrictedIndices;
    public static final JsonpDeserializer<UserIndicesPrivileges> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserIndicesPrivileges::setupUserIndicesPrivilegesDeserializer);

    private UserIndicesPrivileges(Builder builder) {
        this.fieldSecurity = ApiTypeHelper.unmodifiable(builder.fieldSecurity);
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.privileges = ApiTypeHelper.unmodifiableRequired(builder.privileges, (Object)this, "privileges");
        this.query = ApiTypeHelper.unmodifiable(builder.query);
        this.allowRestrictedIndices = ApiTypeHelper.requireNonNull(builder.allowRestrictedIndices, (Object)this, "allowRestrictedIndices", false);
    }

    public static UserIndicesPrivileges of(Function<Builder, ObjectBuilder<UserIndicesPrivileges>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldSecurity> fieldSecurity() {
        return this.fieldSecurity;
    }

    public final List<String> names() {
        return this.names;
    }

    public final List<String> privileges() {
        return this.privileges;
    }

    public final List<Query> query() {
        return this.query;
    }

    public final boolean allowRestrictedIndices() {
        return this.allowRestrictedIndices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fieldSecurity)) {
            generator.writeKey("field_security");
            generator.writeStartArray();
            for (FieldSecurity fieldSecurity : this.fieldSecurity) {
                fieldSecurity.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (String string : this.names) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.privileges)) {
            generator.writeKey("privileges");
            generator.writeStartArray();
            for (String string : this.privileges) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.query)) {
            generator.writeKey("query");
            generator.writeStartArray();
            for (Query query : this.query) {
                generator.write(JsonpUtils.toJsonString(query, mapper));
            }
            generator.writeEnd();
        }
        generator.writeKey("allow_restricted_indices");
        generator.write(this.allowRestrictedIndices);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUserIndicesPrivilegesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fieldSecurity, JsonpDeserializer.arrayDeserializer(FieldSecurity._DESERIALIZER), "field_security");
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "names");
        op.add(Builder::privileges, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "privileges");
        op.add(Builder::query, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.jsonString(Query._DESERIALIZER)), "query");
        op.add(Builder::allowRestrictedIndices, JsonpDeserializer.booleanDeserializer(), "allow_restricted_indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UserIndicesPrivileges> {
        @Nullable
        private List<FieldSecurity> fieldSecurity;
        private List<String> names;
        private List<String> privileges;
        @Nullable
        private List<Query> query;
        private Boolean allowRestrictedIndices;

        public Builder() {
        }

        private Builder(UserIndicesPrivileges instance) {
            this.fieldSecurity = instance.fieldSecurity;
            this.names = instance.names;
            this.privileges = instance.privileges;
            this.query = instance.query;
            this.allowRestrictedIndices = instance.allowRestrictedIndices;
        }

        public final Builder fieldSecurity(List<FieldSecurity> list) {
            this.fieldSecurity = Builder._listAddAll(this.fieldSecurity, list);
            return this;
        }

        public final Builder fieldSecurity(FieldSecurity value, FieldSecurity ... values) {
            this.fieldSecurity = Builder._listAdd(this.fieldSecurity, value, values);
            return this;
        }

        public final Builder fieldSecurity(Function<FieldSecurity.Builder, ObjectBuilder<FieldSecurity>> fn) {
            return this.fieldSecurity(fn.apply(new FieldSecurity.Builder()).build(), new FieldSecurity[0]);
        }

        public final Builder names(List<String> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(String value, String ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder privileges(List<String> list) {
            this.privileges = Builder._listAddAll(this.privileges, list);
            return this;
        }

        public final Builder privileges(String value, String ... values) {
            this.privileges = Builder._listAdd(this.privileges, value, values);
            return this;
        }

        public final Builder privileges(IndexPrivilege value, IndexPrivilege ... values) {
            this.privileges = Builder._listAdd(this.privileges, value.jsonValue(), (String[])Arrays.stream(values).map(IndexPrivilege::jsonValue).toArray(String[]::new));
            return this;
        }

        public final Builder query(List<Query> list) {
            this.query = Builder._listAddAll(this.query, list);
            return this;
        }

        public final Builder query(Query value, Query ... values) {
            this.query = Builder._listAdd(this.query, value, values);
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build(), new Query[0]);
        }

        public final Builder allowRestrictedIndices(boolean value) {
            this.allowRestrictedIndices = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserIndicesPrivileges build() {
            this._checkSingleUse();
            return new UserIndicesPrivileges(this);
        }
    }
}

