/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch.security.RestrictionWorkflow;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Restriction
implements JsonpSerializable {
    private final List<String> workflows;
    public static final JsonpDeserializer<Restriction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Restriction::setupRestrictionDeserializer);

    private Restriction(Builder builder) {
        this.workflows = ApiTypeHelper.unmodifiableRequired(builder.workflows, (Object)this, "workflows");
    }

    public static Restriction of(Function<Builder, ObjectBuilder<Restriction>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> workflows() {
        return this.workflows;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.workflows)) {
            generator.writeKey("workflows");
            generator.writeStartArray();
            for (String item0 : this.workflows) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRestrictionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::workflows, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "workflows");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Restriction> {
        private List<String> workflows;

        public Builder() {
        }

        private Builder(Restriction instance) {
            this.workflows = instance.workflows;
        }

        public final Builder workflows(List<String> list) {
            this.workflows = Builder._listAddAll(this.workflows, list);
            return this;
        }

        public final Builder workflows(String value, String ... values) {
            this.workflows = Builder._listAdd(this.workflows, value, values);
            return this;
        }

        public final Builder workflows(RestrictionWorkflow value, RestrictionWorkflow ... values) {
            this.workflows = Builder._listAdd(this.workflows, value.jsonValue(), (String[])Arrays.stream(values).map(RestrictionWorkflow::jsonValue).toArray(String[]::new));
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Restriction build() {
            this._checkSingleUse();
            return new Restriction(this);
        }
    }
}

