/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetUserProfileResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetUserProfileRequest
extends RequestBase {
    private final List<String> data;
    private final List<String> uid;
    public static final Endpoint<GetUserProfileRequest, GetUserProfileResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetUserProfileRequest, GetUserProfileResponse>("es/security.get_user_profile", request -> "GET", request -> {
        boolean _uid = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/profile");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.uid.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _uid = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("uid", request.uid.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.data)) {
            params.put("data", request.data.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetUserProfileResponse._DESERIALIZER);

    private GetUserProfileRequest(Builder builder) {
        this.data = ApiTypeHelper.unmodifiable(builder.data);
        this.uid = ApiTypeHelper.unmodifiableRequired(builder.uid, (Object)this, "uid");
    }

    public static GetUserProfileRequest of(Function<Builder, ObjectBuilder<GetUserProfileRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> data() {
        return this.data;
    }

    public final List<String> uid() {
        return this.uid;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetUserProfileRequest> {
        @Nullable
        private List<String> data;
        private List<String> uid;

        public Builder() {
        }

        private Builder(GetUserProfileRequest instance) {
            this.data = instance.data;
            this.uid = instance.uid;
        }

        public final Builder data(List<String> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        public final Builder data(String value, String ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        public final Builder uid(List<String> list) {
            this.uid = Builder._listAddAll(this.uid, list);
            return this;
        }

        public final Builder uid(String value, String ... values) {
            this.uid = Builder._listAdd(this.uid, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetUserProfileRequest build() {
            this._checkSingleUse();
            return new GetUserProfileRequest(this);
        }
    }
}

