/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.search_application.EventType;
import co.elastic.clients.elasticsearch.search_application.PostBehavioralAnalyticsEventResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PostBehavioralAnalyticsEventRequest
extends RequestBase
implements JsonpSerializable {
    private final String collectionName;
    @Nullable
    private final Boolean debug;
    private final EventType eventType;
    private final JsonData payload;
    public static final JsonpDeserializer<PostBehavioralAnalyticsEventRequest> _DESERIALIZER = PostBehavioralAnalyticsEventRequest.createPostBehavioralAnalyticsEventRequestDeserializer();
    public static final Endpoint<PostBehavioralAnalyticsEventRequest, PostBehavioralAnalyticsEventResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PostBehavioralAnalyticsEventRequest, PostBehavioralAnalyticsEventResponse>("es/search_application.post_behavioral_analytics_event", request -> "POST", request -> {
        boolean _eventType = true;
        int _collectionName = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_application");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.collectionName, buf);
            buf.append("/event");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.eventType.jsonValue(), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _eventType = true;
        int _collectionName = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("collectionName", request.collectionName);
            params.put("eventType", request.eventType.jsonValue());
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.debug != null) {
            params.put("debug", String.valueOf(request.debug));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PostBehavioralAnalyticsEventResponse._DESERIALIZER);

    private PostBehavioralAnalyticsEventRequest(Builder builder) {
        this.collectionName = ApiTypeHelper.requireNonNull(builder.collectionName, this, "collectionName");
        this.debug = builder.debug;
        this.eventType = ApiTypeHelper.requireNonNull(builder.eventType, this, "eventType");
        this.payload = ApiTypeHelper.requireNonNull(builder.payload, this, "payload");
    }

    public static PostBehavioralAnalyticsEventRequest of(Function<Builder, ObjectBuilder<PostBehavioralAnalyticsEventRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String collectionName() {
        return this.collectionName;
    }

    @Nullable
    public final Boolean debug() {
        return this.debug;
    }

    public final EventType eventType() {
        return this.eventType;
    }

    public final JsonData payload() {
        return this.payload;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.payload.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static JsonpDeserializer<PostBehavioralAnalyticsEventRequest> createPostBehavioralAnalyticsEventRequestDeserializer() {
        JsonpDeserializer<JsonData> valueDeserializer = JsonData._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().payload((JsonData)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostBehavioralAnalyticsEventRequest> {
        private String collectionName;
        @Nullable
        private Boolean debug;
        private EventType eventType;
        private JsonData payload;

        public Builder() {
        }

        private Builder(PostBehavioralAnalyticsEventRequest instance) {
            this.collectionName = instance.collectionName;
            this.debug = instance.debug;
            this.eventType = instance.eventType;
            this.payload = instance.payload;
        }

        public final Builder collectionName(String value) {
            this.collectionName = value;
            return this;
        }

        public final Builder debug(@Nullable Boolean value) {
            this.debug = value;
            return this;
        }

        public final Builder eventType(EventType value) {
            this.eventType = value;
            return this;
        }

        public final Builder payload(JsonData value) {
            this.payload = value;
            return this;
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            JsonData value = JsonData._DESERIALIZER.deserialize(parser, mapper);
            return this.payload(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostBehavioralAnalyticsEventRequest build() {
            this._checkSingleUse();
            return new PostBehavioralAnalyticsEventRequest(this);
        }
    }
}

