/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_rollup_caps;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RollupFieldSummary
implements JsonpSerializable {
    private final String agg;
    @Nullable
    private final Time calendarInterval;
    @Nullable
    private final String timeZone;
    public static final JsonpDeserializer<RollupFieldSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupFieldSummary::setupRollupFieldSummaryDeserializer);

    private RollupFieldSummary(Builder builder) {
        this.agg = ApiTypeHelper.requireNonNull(builder.agg, this, "agg");
        this.calendarInterval = builder.calendarInterval;
        this.timeZone = builder.timeZone;
    }

    public static RollupFieldSummary of(Function<Builder, ObjectBuilder<RollupFieldSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String agg() {
        return this.agg;
    }

    @Nullable
    public final Time calendarInterval() {
        return this.calendarInterval;
    }

    @Nullable
    public final String timeZone() {
        return this.timeZone;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("agg");
        generator.write(this.agg);
        if (this.calendarInterval != null) {
            generator.writeKey("calendar_interval");
            this.calendarInterval.serialize(generator, mapper);
        }
        if (this.timeZone != null) {
            generator.writeKey("time_zone");
            generator.write(this.timeZone);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRollupFieldSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::agg, JsonpDeserializer.stringDeserializer(), "agg");
        op.add(Builder::calendarInterval, Time._DESERIALIZER, "calendar_interval");
        op.add(Builder::timeZone, JsonpDeserializer.stringDeserializer(), "time_zone");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RollupFieldSummary> {
        private String agg;
        @Nullable
        private Time calendarInterval;
        @Nullable
        private String timeZone;

        public Builder() {
        }

        private Builder(RollupFieldSummary instance) {
            this.agg = instance.agg;
            this.calendarInterval = instance.calendarInterval;
            this.timeZone = instance.timeZone;
        }

        public final Builder agg(String value) {
            this.agg = value;
            return this;
        }

        public final Builder calendarInterval(@Nullable Time value) {
            this.calendarInterval = value;
            return this;
        }

        public final Builder calendarInterval(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.calendarInterval(fn.apply(new Time.Builder()).build());
        }

        public final Builder timeZone(@Nullable String value) {
            this.timeZone = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RollupFieldSummary build() {
            this._checkSingleUse();
            return new RollupFieldSummary(this);
        }
    }
}

