/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Context;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Scripting
implements JsonpSerializable {
    @Nullable
    private final Long cacheEvictions;
    @Nullable
    private final Long compilations;
    private final Map<String, Long> compilationsHistory;
    @Nullable
    private final Long compilationLimitTriggered;
    private final List<Context> contexts;
    public static final JsonpDeserializer<Scripting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Scripting::setupScriptingDeserializer);

    private Scripting(Builder builder) {
        this.cacheEvictions = builder.cacheEvictions;
        this.compilations = builder.compilations;
        this.compilationsHistory = ApiTypeHelper.unmodifiable(builder.compilationsHistory);
        this.compilationLimitTriggered = builder.compilationLimitTriggered;
        this.contexts = ApiTypeHelper.unmodifiable(builder.contexts);
    }

    public static Scripting of(Function<Builder, ObjectBuilder<Scripting>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Long cacheEvictions() {
        return this.cacheEvictions;
    }

    @Nullable
    public final Long compilations() {
        return this.compilations;
    }

    public final Map<String, Long> compilationsHistory() {
        return this.compilationsHistory;
    }

    @Nullable
    public final Long compilationLimitTriggered() {
        return this.compilationLimitTriggered;
    }

    public final List<Context> contexts() {
        return this.contexts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.cacheEvictions != null) {
            generator.writeKey("cache_evictions");
            generator.write(this.cacheEvictions.longValue());
        }
        if (this.compilations != null) {
            generator.writeKey("compilations");
            generator.write(this.compilations.longValue());
        }
        if (ApiTypeHelper.isDefined(this.compilationsHistory)) {
            generator.writeKey("compilations_history");
            generator.writeStartObject();
            for (Map.Entry<String, Long> entry : this.compilationsHistory.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue().longValue());
            }
            generator.writeEnd();
        }
        if (this.compilationLimitTriggered != null) {
            generator.writeKey("compilation_limit_triggered");
            generator.write(this.compilationLimitTriggered.longValue());
        }
        if (ApiTypeHelper.isDefined(this.contexts)) {
            generator.writeKey("contexts");
            generator.writeStartArray();
            for (Context context : this.contexts) {
                context.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupScriptingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheEvictions, JsonpDeserializer.longDeserializer(), "cache_evictions");
        op.add(Builder::compilations, JsonpDeserializer.longDeserializer(), "compilations");
        op.add(Builder::compilationsHistory, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "compilations_history");
        op.add(Builder::compilationLimitTriggered, JsonpDeserializer.longDeserializer(), "compilation_limit_triggered");
        op.add(Builder::contexts, JsonpDeserializer.arrayDeserializer(Context._DESERIALIZER), "contexts");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Scripting> {
        @Nullable
        private Long cacheEvictions;
        @Nullable
        private Long compilations;
        @Nullable
        private Map<String, Long> compilationsHistory;
        @Nullable
        private Long compilationLimitTriggered;
        @Nullable
        private List<Context> contexts;

        public Builder() {
        }

        private Builder(Scripting instance) {
            this.cacheEvictions = instance.cacheEvictions;
            this.compilations = instance.compilations;
            this.compilationsHistory = instance.compilationsHistory;
            this.compilationLimitTriggered = instance.compilationLimitTriggered;
            this.contexts = instance.contexts;
        }

        public final Builder cacheEvictions(@Nullable Long value) {
            this.cacheEvictions = value;
            return this;
        }

        public final Builder compilations(@Nullable Long value) {
            this.compilations = value;
            return this;
        }

        public final Builder compilationsHistory(Map<String, Long> map) {
            this.compilationsHistory = Builder._mapPutAll(this.compilationsHistory, map);
            return this;
        }

        public final Builder compilationsHistory(String key, Long value) {
            this.compilationsHistory = Builder._mapPut(this.compilationsHistory, key, value);
            return this;
        }

        public final Builder compilationLimitTriggered(@Nullable Long value) {
            this.compilationLimitTriggered = value;
            return this;
        }

        public final Builder contexts(List<Context> list) {
            this.contexts = Builder._listAddAll(this.contexts, list);
            return this;
        }

        public final Builder contexts(Context value, Context ... values) {
            this.contexts = Builder._listAdd(this.contexts, value, values);
            return this;
        }

        public final Builder contexts(Function<Context.Builder, ObjectBuilder<Context>> fn) {
            return this.contexts(fn.apply(new Context.Builder()).build(), new Context[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Scripting build() {
            this._checkSingleUse();
            return new Scripting(this);
        }
    }
}

