/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RepositoryLocation
implements JsonpSerializable {
    private final String basePath;
    @Nullable
    private final String container;
    @Nullable
    private final String bucket;
    public static final JsonpDeserializer<RepositoryLocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryLocation::setupRepositoryLocationDeserializer);

    private RepositoryLocation(Builder builder) {
        this.basePath = ApiTypeHelper.requireNonNull(builder.basePath, this, "basePath");
        this.container = builder.container;
        this.bucket = builder.bucket;
    }

    public static RepositoryLocation of(Function<Builder, ObjectBuilder<RepositoryLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String basePath() {
        return this.basePath;
    }

    @Nullable
    public final String container() {
        return this.container;
    }

    @Nullable
    public final String bucket() {
        return this.bucket;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("base_path");
        generator.write(this.basePath);
        if (this.container != null) {
            generator.writeKey("container");
            generator.write(this.container);
        }
        if (this.bucket != null) {
            generator.writeKey("bucket");
            generator.write(this.bucket);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRepositoryLocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::basePath, JsonpDeserializer.stringDeserializer(), "base_path");
        op.add(Builder::container, JsonpDeserializer.stringDeserializer(), "container");
        op.add(Builder::bucket, JsonpDeserializer.stringDeserializer(), "bucket");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RepositoryLocation> {
        private String basePath;
        @Nullable
        private String container;
        @Nullable
        private String bucket;

        public Builder() {
        }

        private Builder(RepositoryLocation instance) {
            this.basePath = instance.basePath;
            this.container = instance.container;
            this.bucket = instance.bucket;
        }

        public final Builder basePath(String value) {
            this.basePath = value;
            return this;
        }

        public final Builder container(@Nullable String value) {
            this.container = value;
            return this;
        }

        public final Builder bucket(@Nullable String value) {
            this.bucket = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RepositoryLocation build() {
            this._checkSingleUse();
            return new RepositoryLocation(this);
        }
    }
}

