/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeReloadResult
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final ErrorCause reloadException;
    public static final JsonpDeserializer<NodeReloadResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeReloadResult::setupNodeReloadResultDeserializer);

    private NodeReloadResult(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reloadException = builder.reloadException;
    }

    public static NodeReloadResult of(Function<Builder, ObjectBuilder<NodeReloadResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final ErrorCause reloadException() {
        return this.reloadException;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.reloadException != null) {
            generator.writeKey("reload_exception");
            this.reloadException.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNodeReloadResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reloadException, ErrorCause._DESERIALIZER, "reload_exception");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeReloadResult> {
        private String name;
        @Nullable
        private ErrorCause reloadException;

        public Builder() {
        }

        private Builder(NodeReloadResult instance) {
            this.name = instance.name;
            this.reloadException = instance.reloadException;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder reloadException(@Nullable ErrorCause value) {
            this.reloadException = value;
            return this;
        }

        public final Builder reloadException(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.reloadException(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeReloadResult build() {
            this._checkSingleUse();
            return new NodeReloadResult(this);
        }
    }
}

