/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.HttpRouteRequests;
import co.elastic.clients.elasticsearch.nodes.HttpRouteResponses;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class HttpRoute
implements JsonpSerializable {
    private final HttpRouteRequests requests;
    private final HttpRouteResponses responses;
    public static final JsonpDeserializer<HttpRoute> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpRoute::setupHttpRouteDeserializer);

    private HttpRoute(Builder builder) {
        this.requests = ApiTypeHelper.requireNonNull(builder.requests, this, "requests");
        this.responses = ApiTypeHelper.requireNonNull(builder.responses, this, "responses");
    }

    public static HttpRoute of(Function<Builder, ObjectBuilder<HttpRoute>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final HttpRouteRequests requests() {
        return this.requests;
    }

    public final HttpRouteResponses responses() {
        return this.responses;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("requests");
        this.requests.serialize(generator, mapper);
        generator.writeKey("responses");
        this.responses.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupHttpRouteDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::requests, HttpRouteRequests._DESERIALIZER, "requests");
        op.add(Builder::responses, HttpRouteResponses._DESERIALIZER, "responses");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<HttpRoute> {
        private HttpRouteRequests requests;
        private HttpRouteResponses responses;

        public Builder() {
        }

        private Builder(HttpRoute instance) {
            this.requests = instance.requests;
            this.responses = instance.responses;
        }

        public final Builder requests(HttpRouteRequests value) {
            this.requests = value;
            return this;
        }

        public final Builder requests(Function<HttpRouteRequests.Builder, ObjectBuilder<HttpRouteRequests>> fn) {
            return this.requests(fn.apply(new HttpRouteRequests.Builder()).build());
        }

        public final Builder responses(HttpRouteResponses value) {
            this.responses = value;
            return this;
        }

        public final Builder responses(Function<HttpRouteResponses.Builder, ObjectBuilder<HttpRouteResponses>> fn) {
            return this.responses(fn.apply(new HttpRouteResponses.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HttpRoute build() {
            this._checkSingleUse();
            return new HttpRoute(this);
        }
    }
}

