/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CpuAcct
implements JsonpSerializable {
    @Nullable
    private final String controlGroup;
    @Nullable
    private final Long usageNanos;
    public static final JsonpDeserializer<CpuAcct> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CpuAcct::setupCpuAcctDeserializer);

    private CpuAcct(Builder builder) {
        this.controlGroup = builder.controlGroup;
        this.usageNanos = builder.usageNanos;
    }

    public static CpuAcct of(Function<Builder, ObjectBuilder<CpuAcct>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String controlGroup() {
        return this.controlGroup;
    }

    @Nullable
    public final Long usageNanos() {
        return this.usageNanos;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.controlGroup != null) {
            generator.writeKey("control_group");
            generator.write(this.controlGroup);
        }
        if (this.usageNanos != null) {
            generator.writeKey("usage_nanos");
            generator.write(this.usageNanos.longValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCpuAcctDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::controlGroup, JsonpDeserializer.stringDeserializer(), "control_group");
        op.add(Builder::usageNanos, JsonpDeserializer.longDeserializer(), "usage_nanos");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CpuAcct> {
        @Nullable
        private String controlGroup;
        @Nullable
        private Long usageNanos;

        public Builder() {
        }

        private Builder(CpuAcct instance) {
            this.controlGroup = instance.controlGroup;
            this.usageNanos = instance.usageNanos;
        }

        public final Builder controlGroup(@Nullable String value) {
            this.controlGroup = value;
            return this;
        }

        public final Builder usageNanos(@Nullable Long value) {
            this.usageNanos = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CpuAcct build() {
            this._checkSingleUse();
            return new CpuAcct(this);
        }
    }
}

