/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.CgroupCpuStat;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CgroupCpu
implements JsonpSerializable {
    @Nullable
    private final String controlGroup;
    @Nullable
    private final Integer cfsPeriodMicros;
    @Nullable
    private final Integer cfsQuotaMicros;
    @Nullable
    private final CgroupCpuStat stat;
    public static final JsonpDeserializer<CgroupCpu> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CgroupCpu::setupCgroupCpuDeserializer);

    private CgroupCpu(Builder builder) {
        this.controlGroup = builder.controlGroup;
        this.cfsPeriodMicros = builder.cfsPeriodMicros;
        this.cfsQuotaMicros = builder.cfsQuotaMicros;
        this.stat = builder.stat;
    }

    public static CgroupCpu of(Function<Builder, ObjectBuilder<CgroupCpu>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String controlGroup() {
        return this.controlGroup;
    }

    @Nullable
    public final Integer cfsPeriodMicros() {
        return this.cfsPeriodMicros;
    }

    @Nullable
    public final Integer cfsQuotaMicros() {
        return this.cfsQuotaMicros;
    }

    @Nullable
    public final CgroupCpuStat stat() {
        return this.stat;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.controlGroup != null) {
            generator.writeKey("control_group");
            generator.write(this.controlGroup);
        }
        if (this.cfsPeriodMicros != null) {
            generator.writeKey("cfs_period_micros");
            generator.write(this.cfsPeriodMicros.intValue());
        }
        if (this.cfsQuotaMicros != null) {
            generator.writeKey("cfs_quota_micros");
            generator.write(this.cfsQuotaMicros.intValue());
        }
        if (this.stat != null) {
            generator.writeKey("stat");
            this.stat.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCgroupCpuDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::controlGroup, JsonpDeserializer.stringDeserializer(), "control_group");
        op.add(Builder::cfsPeriodMicros, JsonpDeserializer.integerDeserializer(), "cfs_period_micros");
        op.add(Builder::cfsQuotaMicros, JsonpDeserializer.integerDeserializer(), "cfs_quota_micros");
        op.add(Builder::stat, CgroupCpuStat._DESERIALIZER, "stat");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CgroupCpu> {
        @Nullable
        private String controlGroup;
        @Nullable
        private Integer cfsPeriodMicros;
        @Nullable
        private Integer cfsQuotaMicros;
        @Nullable
        private CgroupCpuStat stat;

        public Builder() {
        }

        private Builder(CgroupCpu instance) {
            this.controlGroup = instance.controlGroup;
            this.cfsPeriodMicros = instance.cfsPeriodMicros;
            this.cfsQuotaMicros = instance.cfsQuotaMicros;
            this.stat = instance.stat;
        }

        public final Builder controlGroup(@Nullable String value) {
            this.controlGroup = value;
            return this;
        }

        public final Builder cfsPeriodMicros(@Nullable Integer value) {
            this.cfsPeriodMicros = value;
            return this;
        }

        public final Builder cfsQuotaMicros(@Nullable Integer value) {
            this.cfsQuotaMicros = value;
            return this;
        }

        public final Builder stat(@Nullable CgroupCpuStat value) {
            this.stat = value;
            return this;
        }

        public final Builder stat(Function<CgroupCpuStat.Builder, ObjectBuilder<CgroupCpuStat>> fn) {
            return this.stat(fn.apply(new CgroupCpuStat.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CgroupCpu build() {
            this._checkSingleUse();
            return new CgroupCpu(this);
        }
    }
}

