/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.info;

import co.elastic.clients.elasticsearch.ml.info.AnomalyDetectors;
import co.elastic.clients.elasticsearch.ml.info.Datafeeds;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Defaults
implements JsonpSerializable {
    private final AnomalyDetectors anomalyDetectors;
    private final Datafeeds datafeeds;
    public static final JsonpDeserializer<Defaults> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Defaults::setupDefaultsDeserializer);

    private Defaults(Builder builder) {
        this.anomalyDetectors = ApiTypeHelper.requireNonNull(builder.anomalyDetectors, this, "anomalyDetectors");
        this.datafeeds = ApiTypeHelper.requireNonNull(builder.datafeeds, this, "datafeeds");
    }

    public static Defaults of(Function<Builder, ObjectBuilder<Defaults>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AnomalyDetectors anomalyDetectors() {
        return this.anomalyDetectors;
    }

    public final Datafeeds datafeeds() {
        return this.datafeeds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("anomaly_detectors");
        this.anomalyDetectors.serialize(generator, mapper);
        generator.writeKey("datafeeds");
        this.datafeeds.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDefaultsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyDetectors, AnomalyDetectors._DESERIALIZER, "anomaly_detectors");
        op.add(Builder::datafeeds, Datafeeds._DESERIALIZER, "datafeeds");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Defaults> {
        private AnomalyDetectors anomalyDetectors;
        private Datafeeds datafeeds;

        public Builder() {
        }

        private Builder(Defaults instance) {
            this.anomalyDetectors = instance.anomalyDetectors;
            this.datafeeds = instance.datafeeds;
        }

        public final Builder anomalyDetectors(AnomalyDetectors value) {
            this.anomalyDetectors = value;
            return this;
        }

        public final Builder anomalyDetectors(Function<AnomalyDetectors.Builder, ObjectBuilder<AnomalyDetectors>> fn) {
            return this.anomalyDetectors(fn.apply(new AnomalyDetectors.Builder()).build());
        }

        public final Builder datafeeds(Datafeeds value) {
            this.datafeeds = value;
            return this;
        }

        public final Builder datafeeds(Function<Datafeeds.Builder, ObjectBuilder<Datafeeds>> fn) {
            return this.datafeeds(fn.apply(new Datafeeds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Defaults build() {
            this._checkSingleUse();
            return new Defaults(this);
        }
    }
}

