/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.get_memory_stats;

import co.elastic.clients.elasticsearch.ml.get_memory_stats.MemMlStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MemStats
implements JsonpSerializable {
    @Nullable
    private final String adjustedTotal;
    private final int adjustedTotalInBytes;
    @Nullable
    private final String total;
    private final int totalInBytes;
    private final MemMlStats ml;
    public static final JsonpDeserializer<MemStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MemStats::setupMemStatsDeserializer);

    private MemStats(Builder builder) {
        this.adjustedTotal = builder.adjustedTotal;
        this.adjustedTotalInBytes = ApiTypeHelper.requireNonNull(builder.adjustedTotalInBytes, (Object)this, "adjustedTotalInBytes", 0);
        this.total = builder.total;
        this.totalInBytes = ApiTypeHelper.requireNonNull(builder.totalInBytes, (Object)this, "totalInBytes", 0);
        this.ml = ApiTypeHelper.requireNonNull(builder.ml, this, "ml");
    }

    public static MemStats of(Function<Builder, ObjectBuilder<MemStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String adjustedTotal() {
        return this.adjustedTotal;
    }

    public final int adjustedTotalInBytes() {
        return this.adjustedTotalInBytes;
    }

    @Nullable
    public final String total() {
        return this.total;
    }

    public final int totalInBytes() {
        return this.totalInBytes;
    }

    public final MemMlStats ml() {
        return this.ml;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adjustedTotal != null) {
            generator.writeKey("adjusted_total");
            generator.write(this.adjustedTotal);
        }
        generator.writeKey("adjusted_total_in_bytes");
        generator.write(this.adjustedTotalInBytes);
        if (this.total != null) {
            generator.writeKey("total");
            generator.write(this.total);
        }
        generator.writeKey("total_in_bytes");
        generator.write(this.totalInBytes);
        generator.writeKey("ml");
        this.ml.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMemStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adjustedTotal, JsonpDeserializer.stringDeserializer(), "adjusted_total");
        op.add(Builder::adjustedTotalInBytes, JsonpDeserializer.integerDeserializer(), "adjusted_total_in_bytes");
        op.add(Builder::total, JsonpDeserializer.stringDeserializer(), "total");
        op.add(Builder::totalInBytes, JsonpDeserializer.integerDeserializer(), "total_in_bytes");
        op.add(Builder::ml, MemMlStats._DESERIALIZER, "ml");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MemStats> {
        @Nullable
        private String adjustedTotal;
        private Integer adjustedTotalInBytes;
        @Nullable
        private String total;
        private Integer totalInBytes;
        private MemMlStats ml;

        public Builder() {
        }

        private Builder(MemStats instance) {
            this.adjustedTotal = instance.adjustedTotal;
            this.adjustedTotalInBytes = instance.adjustedTotalInBytes;
            this.total = instance.total;
            this.totalInBytes = instance.totalInBytes;
            this.ml = instance.ml;
        }

        public final Builder adjustedTotal(@Nullable String value) {
            this.adjustedTotal = value;
            return this;
        }

        public final Builder adjustedTotalInBytes(int value) {
            this.adjustedTotalInBytes = value;
            return this;
        }

        public final Builder total(@Nullable String value) {
            this.total = value;
            return this;
        }

        public final Builder totalInBytes(int value) {
            this.totalInBytes = value;
            return this;
        }

        public final Builder ml(MemMlStats value) {
            this.ml = value;
            return this;
        }

        public final Builder ml(Function<MemMlStats.Builder, ObjectBuilder<MemMlStats>> fn) {
            return this.ml(fn.apply(new MemMlStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MemStats build() {
            this._checkSingleUse();
            return new MemStats(this);
        }
    }
}

