/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.get_memory_stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JvmStats
implements JsonpSerializable {
    @Nullable
    private final String heapMax;
    private final int heapMaxInBytes;
    @Nullable
    private final String javaInference;
    private final int javaInferenceInBytes;
    @Nullable
    private final String javaInferenceMax;
    private final int javaInferenceMaxInBytes;
    public static final JsonpDeserializer<JvmStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JvmStats::setupJvmStatsDeserializer);

    private JvmStats(Builder builder) {
        this.heapMax = builder.heapMax;
        this.heapMaxInBytes = ApiTypeHelper.requireNonNull(builder.heapMaxInBytes, (Object)this, "heapMaxInBytes", 0);
        this.javaInference = builder.javaInference;
        this.javaInferenceInBytes = ApiTypeHelper.requireNonNull(builder.javaInferenceInBytes, (Object)this, "javaInferenceInBytes", 0);
        this.javaInferenceMax = builder.javaInferenceMax;
        this.javaInferenceMaxInBytes = ApiTypeHelper.requireNonNull(builder.javaInferenceMaxInBytes, (Object)this, "javaInferenceMaxInBytes", 0);
    }

    public static JvmStats of(Function<Builder, ObjectBuilder<JvmStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String heapMax() {
        return this.heapMax;
    }

    public final int heapMaxInBytes() {
        return this.heapMaxInBytes;
    }

    @Nullable
    public final String javaInference() {
        return this.javaInference;
    }

    public final int javaInferenceInBytes() {
        return this.javaInferenceInBytes;
    }

    @Nullable
    public final String javaInferenceMax() {
        return this.javaInferenceMax;
    }

    public final int javaInferenceMaxInBytes() {
        return this.javaInferenceMaxInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.heapMax != null) {
            generator.writeKey("heap_max");
            generator.write(this.heapMax);
        }
        generator.writeKey("heap_max_in_bytes");
        generator.write(this.heapMaxInBytes);
        if (this.javaInference != null) {
            generator.writeKey("java_inference");
            generator.write(this.javaInference);
        }
        generator.writeKey("java_inference_in_bytes");
        generator.write(this.javaInferenceInBytes);
        if (this.javaInferenceMax != null) {
            generator.writeKey("java_inference_max");
            generator.write(this.javaInferenceMax);
        }
        generator.writeKey("java_inference_max_in_bytes");
        generator.write(this.javaInferenceMaxInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupJvmStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::heapMax, JsonpDeserializer.stringDeserializer(), "heap_max");
        op.add(Builder::heapMaxInBytes, JsonpDeserializer.integerDeserializer(), "heap_max_in_bytes");
        op.add(Builder::javaInference, JsonpDeserializer.stringDeserializer(), "java_inference");
        op.add(Builder::javaInferenceInBytes, JsonpDeserializer.integerDeserializer(), "java_inference_in_bytes");
        op.add(Builder::javaInferenceMax, JsonpDeserializer.stringDeserializer(), "java_inference_max");
        op.add(Builder::javaInferenceMaxInBytes, JsonpDeserializer.integerDeserializer(), "java_inference_max_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JvmStats> {
        @Nullable
        private String heapMax;
        private Integer heapMaxInBytes;
        @Nullable
        private String javaInference;
        private Integer javaInferenceInBytes;
        @Nullable
        private String javaInferenceMax;
        private Integer javaInferenceMaxInBytes;

        public Builder() {
        }

        private Builder(JvmStats instance) {
            this.heapMax = instance.heapMax;
            this.heapMaxInBytes = instance.heapMaxInBytes;
            this.javaInference = instance.javaInference;
            this.javaInferenceInBytes = instance.javaInferenceInBytes;
            this.javaInferenceMax = instance.javaInferenceMax;
            this.javaInferenceMaxInBytes = instance.javaInferenceMaxInBytes;
        }

        public final Builder heapMax(@Nullable String value) {
            this.heapMax = value;
            return this;
        }

        public final Builder heapMaxInBytes(int value) {
            this.heapMaxInBytes = value;
            return this;
        }

        public final Builder javaInference(@Nullable String value) {
            this.javaInference = value;
            return this;
        }

        public final Builder javaInferenceInBytes(int value) {
            this.javaInferenceInBytes = value;
            return this;
        }

        public final Builder javaInferenceMax(@Nullable String value) {
            this.javaInferenceMax = value;
            return this;
        }

        public final Builder javaInferenceMaxInBytes(int value) {
            this.javaInferenceMaxInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JvmStats build() {
            this._checkSingleUse();
            return new JvmStats(this);
        }
    }
}

