/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.get_calendars;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Calendar
implements JsonpSerializable {
    private final String calendarId;
    @Nullable
    private final String description;
    private final List<String> jobIds;
    public static final JsonpDeserializer<Calendar> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Calendar::setupCalendarDeserializer);

    private Calendar(Builder builder) {
        this.calendarId = ApiTypeHelper.requireNonNull(builder.calendarId, this, "calendarId");
        this.description = builder.description;
        this.jobIds = ApiTypeHelper.unmodifiableRequired(builder.jobIds, (Object)this, "jobIds");
    }

    public static Calendar of(Function<Builder, ObjectBuilder<Calendar>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final List<String> jobIds() {
        return this.jobIds;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("calendar_id");
        generator.write(this.calendarId);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (ApiTypeHelper.isDefined(this.jobIds)) {
            generator.writeKey("job_ids");
            generator.writeStartArray();
            for (String item0 : this.jobIds) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCalendarDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::calendarId, JsonpDeserializer.stringDeserializer(), "calendar_id");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::jobIds, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "job_ids");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Calendar> {
        private String calendarId;
        @Nullable
        private String description;
        private List<String> jobIds;

        public Builder() {
        }

        private Builder(Calendar instance) {
            this.calendarId = instance.calendarId;
            this.description = instance.description;
            this.jobIds = instance.jobIds;
        }

        public final Builder calendarId(String value) {
            this.calendarId = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder jobIds(List<String> list) {
            this.jobIds = Builder._listAddAll(this.jobIds, list);
            return this;
        }

        public final Builder jobIds(String value, String ... values) {
            this.jobIds = Builder._listAdd(this.jobIds, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Calendar build() {
            this._checkSingleUse();
            return new Calendar(this);
        }
    }
}

