/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigUpdateVariant;
import co.elastic.clients.elasticsearch.ml.NlpTokenizationUpdateOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ZeroShotClassificationInferenceUpdateOptions
implements InferenceConfigUpdateVariant,
JsonpSerializable {
    @Nullable
    private final NlpTokenizationUpdateOptions tokenization;
    @Nullable
    private final String resultsField;
    @Nullable
    private final Boolean multiLabel;
    private final List<String> labels;
    public static final JsonpDeserializer<ZeroShotClassificationInferenceUpdateOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ZeroShotClassificationInferenceUpdateOptions::setupZeroShotClassificationInferenceUpdateOptionsDeserializer);

    private ZeroShotClassificationInferenceUpdateOptions(Builder builder) {
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
        this.multiLabel = builder.multiLabel;
        this.labels = ApiTypeHelper.unmodifiableRequired(builder.labels, (Object)this, "labels");
    }

    public static ZeroShotClassificationInferenceUpdateOptions of(Function<Builder, ObjectBuilder<ZeroShotClassificationInferenceUpdateOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigUpdate.Kind _inferenceConfigUpdateKind() {
        return InferenceConfigUpdate.Kind.ZeroShotClassification;
    }

    @Nullable
    public final NlpTokenizationUpdateOptions tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final Boolean multiLabel() {
        return this.multiLabel;
    }

    public final List<String> labels() {
        return this.labels;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.multiLabel != null) {
            generator.writeKey("multi_label");
            generator.write(this.multiLabel.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.labels)) {
            generator.writeKey("labels");
            generator.writeStartArray();
            for (String item0 : this.labels) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupZeroShotClassificationInferenceUpdateOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tokenization, NlpTokenizationUpdateOptions._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::multiLabel, JsonpDeserializer.booleanDeserializer(), "multi_label");
        op.add(Builder::labels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "labels");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ZeroShotClassificationInferenceUpdateOptions> {
        @Nullable
        private NlpTokenizationUpdateOptions tokenization;
        @Nullable
        private String resultsField;
        @Nullable
        private Boolean multiLabel;
        private List<String> labels;

        public Builder() {
        }

        private Builder(ZeroShotClassificationInferenceUpdateOptions instance) {
            this.tokenization = instance.tokenization;
            this.resultsField = instance.resultsField;
            this.multiLabel = instance.multiLabel;
            this.labels = instance.labels;
        }

        public final Builder tokenization(@Nullable NlpTokenizationUpdateOptions value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<NlpTokenizationUpdateOptions.Builder, ObjectBuilder<NlpTokenizationUpdateOptions>> fn) {
            return this.tokenization(fn.apply(new NlpTokenizationUpdateOptions.Builder()).build());
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder multiLabel(@Nullable Boolean value) {
            this.multiLabel = value;
            return this;
        }

        public final Builder labels(List<String> list) {
            this.labels = Builder._listAddAll(this.labels, list);
            return this;
        }

        public final Builder labels(String value, String ... values) {
            this.labels = Builder._listAdd(this.labels, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ZeroShotClassificationInferenceUpdateOptions build() {
            this._checkSingleUse();
            return new ZeroShotClassificationInferenceUpdateOptions(this);
        }
    }
}

