/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.UpgradeJobSnapshotResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class UpgradeJobSnapshotRequest
extends RequestBase {
    private final String jobId;
    private final String snapshotId;
    @Nullable
    private final Time timeout;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<UpgradeJobSnapshotRequest, UpgradeJobSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpgradeJobSnapshotRequest, UpgradeJobSnapshotResponse>("es/ml.upgrade_job_snapshot", request -> "POST", request -> {
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_upgrade");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("jobId", request.jobId);
            params.put("snapshotId", request.snapshotId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, UpgradeJobSnapshotResponse._DESERIALIZER);

    private UpgradeJobSnapshotRequest(Builder builder) {
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.snapshotId = ApiTypeHelper.requireNonNull(builder.snapshotId, this, "snapshotId");
        this.timeout = builder.timeout;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public static UpgradeJobSnapshotRequest of(Function<Builder, ObjectBuilder<UpgradeJobSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpgradeJobSnapshotRequest> {
        private String jobId;
        private String snapshotId;
        @Nullable
        private Time timeout;
        @Nullable
        private Boolean waitForCompletion;

        public Builder() {
        }

        private Builder(UpgradeJobSnapshotRequest instance) {
            this.jobId = instance.jobId;
            this.snapshotId = instance.snapshotId;
            this.timeout = instance.timeout;
            this.waitForCompletion = instance.waitForCompletion;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpgradeJobSnapshotRequest build() {
            this._checkSingleUse();
            return new UpgradeJobSnapshotRequest(this);
        }
    }
}

