/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ml.AdaptiveAllocationsSettings;
import co.elastic.clients.elasticsearch.ml.DeploymentAllocationState;
import co.elastic.clients.elasticsearch.ml.StartTrainedModelDeploymentResponse;
import co.elastic.clients.elasticsearch.ml.TrainingPriority;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class StartTrainedModelDeploymentRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final AdaptiveAllocationsSettings adaptiveAllocations;
    @Nullable
    private final String cacheSize;
    @Nullable
    private final String deploymentId;
    private final String modelId;
    @Nullable
    private final Integer numberOfAllocations;
    @Nullable
    private final TrainingPriority priority;
    @Nullable
    private final Integer queueCapacity;
    @Nullable
    private final Integer threadsPerAllocation;
    @Nullable
    private final Time timeout;
    @Nullable
    private final DeploymentAllocationState waitFor;
    public static final JsonpDeserializer<StartTrainedModelDeploymentRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StartTrainedModelDeploymentRequest::setupStartTrainedModelDeploymentRequestDeserializer);
    public static final Endpoint<StartTrainedModelDeploymentRequest, StartTrainedModelDeploymentResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<StartTrainedModelDeploymentRequest, StartTrainedModelDeploymentResponse>("es/ml.start_trained_model_deployment", request -> "POST", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/deployment");
            buf.append("/_start");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.cacheSize != null) {
            params.put("cache_size", request.cacheSize);
        }
        if (request.threadsPerAllocation != null) {
            params.put("threads_per_allocation", String.valueOf(request.threadsPerAllocation));
        }
        if (request.deploymentId != null) {
            params.put("deployment_id", request.deploymentId);
        }
        if (request.waitFor != null) {
            params.put("wait_for", request.waitFor.jsonValue());
        }
        if (request.numberOfAllocations != null) {
            params.put("number_of_allocations", String.valueOf(request.numberOfAllocations));
        }
        if (request.priority != null) {
            params.put("priority", request.priority.jsonValue());
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        if (request.queueCapacity != null) {
            params.put("queue_capacity", String.valueOf(request.queueCapacity));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, StartTrainedModelDeploymentResponse._DESERIALIZER);

    private StartTrainedModelDeploymentRequest(Builder builder) {
        this.adaptiveAllocations = builder.adaptiveAllocations;
        this.cacheSize = builder.cacheSize;
        this.deploymentId = builder.deploymentId;
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.numberOfAllocations = builder.numberOfAllocations;
        this.priority = builder.priority;
        this.queueCapacity = builder.queueCapacity;
        this.threadsPerAllocation = builder.threadsPerAllocation;
        this.timeout = builder.timeout;
        this.waitFor = builder.waitFor;
    }

    public static StartTrainedModelDeploymentRequest of(Function<Builder, ObjectBuilder<StartTrainedModelDeploymentRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AdaptiveAllocationsSettings adaptiveAllocations() {
        return this.adaptiveAllocations;
    }

    @Nullable
    public final String cacheSize() {
        return this.cacheSize;
    }

    @Nullable
    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer numberOfAllocations() {
        return this.numberOfAllocations;
    }

    @Nullable
    public final TrainingPriority priority() {
        return this.priority;
    }

    @Nullable
    public final Integer queueCapacity() {
        return this.queueCapacity;
    }

    @Nullable
    public final Integer threadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Nullable
    public final DeploymentAllocationState waitFor() {
        return this.waitFor;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adaptiveAllocations != null) {
            generator.writeKey("adaptive_allocations");
            this.adaptiveAllocations.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupStartTrainedModelDeploymentRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveAllocations, AdaptiveAllocationsSettings._DESERIALIZER, "adaptive_allocations");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<StartTrainedModelDeploymentRequest> {
        @Nullable
        private AdaptiveAllocationsSettings adaptiveAllocations;
        @Nullable
        private String cacheSize;
        @Nullable
        private String deploymentId;
        private String modelId;
        @Nullable
        private Integer numberOfAllocations;
        @Nullable
        private TrainingPriority priority;
        @Nullable
        private Integer queueCapacity;
        @Nullable
        private Integer threadsPerAllocation;
        @Nullable
        private Time timeout;
        @Nullable
        private DeploymentAllocationState waitFor;

        public Builder() {
        }

        private Builder(StartTrainedModelDeploymentRequest instance) {
            this.adaptiveAllocations = instance.adaptiveAllocations;
            this.cacheSize = instance.cacheSize;
            this.deploymentId = instance.deploymentId;
            this.modelId = instance.modelId;
            this.numberOfAllocations = instance.numberOfAllocations;
            this.priority = instance.priority;
            this.queueCapacity = instance.queueCapacity;
            this.threadsPerAllocation = instance.threadsPerAllocation;
            this.timeout = instance.timeout;
            this.waitFor = instance.waitFor;
        }

        public final Builder adaptiveAllocations(@Nullable AdaptiveAllocationsSettings value) {
            this.adaptiveAllocations = value;
            return this;
        }

        public final Builder adaptiveAllocations(Function<AdaptiveAllocationsSettings.Builder, ObjectBuilder<AdaptiveAllocationsSettings>> fn) {
            return this.adaptiveAllocations(fn.apply(new AdaptiveAllocationsSettings.Builder()).build());
        }

        public final Builder cacheSize(@Nullable String value) {
            this.cacheSize = value;
            return this;
        }

        public final Builder deploymentId(@Nullable String value) {
            this.deploymentId = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder numberOfAllocations(@Nullable Integer value) {
            this.numberOfAllocations = value;
            return this;
        }

        public final Builder priority(@Nullable TrainingPriority value) {
            this.priority = value;
            return this;
        }

        public final Builder queueCapacity(@Nullable Integer value) {
            this.queueCapacity = value;
            return this;
        }

        public final Builder threadsPerAllocation(@Nullable Integer value) {
            this.threadsPerAllocation = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder waitFor(@Nullable DeploymentAllocationState value) {
            this.waitFor = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StartTrainedModelDeploymentRequest build() {
            this._checkSingleUse();
            return new StartTrainedModelDeploymentRequest(this);
        }
    }
}

