/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.CommonTokenizationConfig;
import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.elasticsearch.ml.TokenizationConfigVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NlpRobertaTokenizationConfig
extends CommonTokenizationConfig
implements TokenizationConfigVariant {
    @Nullable
    private final Boolean addPrefixSpace;
    public static final JsonpDeserializer<NlpRobertaTokenizationConfig> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NlpRobertaTokenizationConfig::setupNlpRobertaTokenizationConfigDeserializer);

    private NlpRobertaTokenizationConfig(Builder builder) {
        super(builder);
        this.addPrefixSpace = builder.addPrefixSpace;
    }

    public static NlpRobertaTokenizationConfig of(Function<Builder, ObjectBuilder<NlpRobertaTokenizationConfig>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizationConfig.Kind _tokenizationConfigKind() {
        return TokenizationConfig.Kind.Roberta;
    }

    @Nullable
    public final Boolean addPrefixSpace() {
        return this.addPrefixSpace;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.addPrefixSpace != null) {
            generator.writeKey("add_prefix_space");
            generator.write(this.addPrefixSpace.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNlpRobertaTokenizationConfigDeserializer(ObjectDeserializer<Builder> op) {
        CommonTokenizationConfig.setupCommonTokenizationConfigDeserializer(op);
        op.add(Builder::addPrefixSpace, JsonpDeserializer.booleanDeserializer(), "add_prefix_space");
    }

    public static class Builder
    extends CommonTokenizationConfig.AbstractBuilder<Builder>
    implements ObjectBuilder<NlpRobertaTokenizationConfig> {
        @Nullable
        private Boolean addPrefixSpace;

        public Builder() {
        }

        private Builder(NlpRobertaTokenizationConfig instance) {
            this.addPrefixSpace = instance.addPrefixSpace;
        }

        public final Builder addPrefixSpace(@Nullable Boolean value) {
            this.addPrefixSpace = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NlpRobertaTokenizationConfig build() {
            this._checkSingleUse();
            return new NlpRobertaTokenizationConfig(this);
        }
    }
}

