/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetTrainedModelsStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetTrainedModelsStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Integer from;
    private final List<String> modelId;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetTrainedModelsStatsRequest, GetTrainedModelsStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetTrainedModelsStatsRequest, GetTrainedModelsStatsResponse>("es/ml.get_trained_models_stats", request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.modelId())) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_stats");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.modelId())) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("modelId", request.modelId.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTrainedModelsStatsResponse._DESERIALIZER);

    private GetTrainedModelsStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.from = builder.from;
        this.modelId = ApiTypeHelper.unmodifiable(builder.modelId);
        this.size = builder.size;
    }

    public static GetTrainedModelsStatsRequest of(Function<Builder, ObjectBuilder<GetTrainedModelsStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    public final List<String> modelId() {
        return this.modelId;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetTrainedModelsStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Integer from;
        @Nullable
        private List<String> modelId;
        @Nullable
        private Integer size;

        public Builder() {
        }

        private Builder(GetTrainedModelsStatsRequest instance) {
            this.allowNoMatch = instance.allowNoMatch;
            this.from = instance.from;
            this.modelId = instance.modelId;
            this.size = instance.size;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder modelId(List<String> list) {
            this.modelId = Builder._listAddAll(this.modelId, list);
            return this;
        }

        public final Builder modelId(String value, String ... values) {
            this.modelId = Builder._listAdd(this.modelId, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetTrainedModelsStatsRequest build() {
            this._checkSingleUse();
            return new GetTrainedModelsStatsRequest(this);
        }
    }
}

