/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetDataFrameAnalyticsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetDataFrameAnalyticsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean excludeGenerated;
    @Nullable
    private final Integer from;
    @Nullable
    private final String id;
    @Nullable
    private final Integer size;
    public static final Endpoint<GetDataFrameAnalyticsRequest, GetDataFrameAnalyticsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetDataFrameAnalyticsRequest, GetDataFrameAnalyticsResponse>("es/ml.get_data_frame_analytics", request -> "GET", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/data_frame");
            buf.append("/analytics");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (request.id() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            params.put("id", request.id);
        }
        if (!propsSet) {
            // empty if block
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDataFrameAnalyticsResponse._DESERIALIZER);

    private GetDataFrameAnalyticsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.excludeGenerated = builder.excludeGenerated;
        this.from = builder.from;
        this.id = builder.id;
        this.size = builder.size;
    }

    public static GetDataFrameAnalyticsRequest of(Function<Builder, ObjectBuilder<GetDataFrameAnalyticsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetDataFrameAnalyticsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean excludeGenerated;
        @Nullable
        private Integer from;
        @Nullable
        private String id;
        @Nullable
        private Integer size;

        public Builder() {
        }

        private Builder(GetDataFrameAnalyticsRequest instance) {
            this.allowNoMatch = instance.allowNoMatch;
            this.excludeGenerated = instance.excludeGenerated;
            this.from = instance.from;
            this.id = instance.id;
            this.size = instance.size;
        }

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataFrameAnalyticsRequest build() {
            this._checkSingleUse();
            return new GetDataFrameAnalyticsRequest(this);
        }
    }
}

