/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.FilterType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FilterRef
implements JsonpSerializable {
    private final String filterId;
    @Nullable
    private final FilterType filterType;
    public static final JsonpDeserializer<FilterRef> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FilterRef::setupFilterRefDeserializer);

    private FilterRef(Builder builder) {
        this.filterId = ApiTypeHelper.requireNonNull(builder.filterId, this, "filterId");
        this.filterType = builder.filterType;
    }

    public static FilterRef of(Function<Builder, ObjectBuilder<FilterRef>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String filterId() {
        return this.filterId;
    }

    @Nullable
    public final FilterType filterType() {
        return this.filterType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("filter_id");
        generator.write(this.filterId);
        if (this.filterType != null) {
            generator.writeKey("filter_type");
            this.filterType.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFilterRefDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filterId, JsonpDeserializer.stringDeserializer(), "filter_id");
        op.add(Builder::filterType, FilterType._DESERIALIZER, "filter_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FilterRef> {
        private String filterId;
        @Nullable
        private FilterType filterType;

        public Builder() {
        }

        private Builder(FilterRef instance) {
            this.filterId = instance.filterId;
            this.filterType = instance.filterType;
        }

        public final Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public final Builder filterType(@Nullable FilterType value) {
            this.filterType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FilterRef build() {
            this._checkSingleUse();
            return new FilterRef(this);
        }
    }
}

