/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ExponentialAverageCalculationContext
implements JsonpSerializable {
    private final double incrementalMetricValueMs;
    @Nullable
    private final Long latestTimestamp;
    @Nullable
    private final Double previousExponentialAverageMs;
    public static final JsonpDeserializer<ExponentialAverageCalculationContext> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExponentialAverageCalculationContext::setupExponentialAverageCalculationContextDeserializer);

    private ExponentialAverageCalculationContext(Builder builder) {
        this.incrementalMetricValueMs = ApiTypeHelper.requireNonNull(builder.incrementalMetricValueMs, (Object)this, "incrementalMetricValueMs", 0.0);
        this.latestTimestamp = builder.latestTimestamp;
        this.previousExponentialAverageMs = builder.previousExponentialAverageMs;
    }

    public static ExponentialAverageCalculationContext of(Function<Builder, ObjectBuilder<ExponentialAverageCalculationContext>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double incrementalMetricValueMs() {
        return this.incrementalMetricValueMs;
    }

    @Nullable
    public final Long latestTimestamp() {
        return this.latestTimestamp;
    }

    @Nullable
    public final Double previousExponentialAverageMs() {
        return this.previousExponentialAverageMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("incremental_metric_value_ms");
        generator.write(this.incrementalMetricValueMs);
        if (this.latestTimestamp != null) {
            generator.writeKey("latest_timestamp");
            generator.write(this.latestTimestamp.longValue());
        }
        if (this.previousExponentialAverageMs != null) {
            generator.writeKey("previous_exponential_average_ms");
            generator.write(this.previousExponentialAverageMs.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupExponentialAverageCalculationContextDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::incrementalMetricValueMs, JsonpDeserializer.doubleDeserializer(), "incremental_metric_value_ms");
        op.add(Builder::latestTimestamp, JsonpDeserializer.longDeserializer(), "latest_timestamp");
        op.add(Builder::previousExponentialAverageMs, JsonpDeserializer.doubleDeserializer(), "previous_exponential_average_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ExponentialAverageCalculationContext> {
        private Double incrementalMetricValueMs;
        @Nullable
        private Long latestTimestamp;
        @Nullable
        private Double previousExponentialAverageMs;

        public Builder() {
        }

        private Builder(ExponentialAverageCalculationContext instance) {
            this.incrementalMetricValueMs = instance.incrementalMetricValueMs;
            this.latestTimestamp = instance.latestTimestamp;
            this.previousExponentialAverageMs = instance.previousExponentialAverageMs;
        }

        public final Builder incrementalMetricValueMs(double value) {
            this.incrementalMetricValueMs = value;
            return this;
        }

        public final Builder latestTimestamp(@Nullable Long value) {
            this.latestTimestamp = value;
            return this;
        }

        public final Builder previousExponentialAverageMs(@Nullable Double value) {
            this.previousExponentialAverageMs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExponentialAverageCalculationContext build() {
            this._checkSingleUse();
            return new ExponentialAverageCalculationContext(this);
        }
    }
}

