/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessor;
import co.elastic.clients.elasticsearch.ml.DataframeAnalysisFeatureProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalysisFeatureProcessorFrequencyEncoding
implements DataframeAnalysisFeatureProcessorVariant,
JsonpSerializable {
    private final String featureName;
    private final String field;
    private final Map<String, Double> frequencyMap;
    public static final JsonpDeserializer<DataframeAnalysisFeatureProcessorFrequencyEncoding> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalysisFeatureProcessorFrequencyEncoding::setupDataframeAnalysisFeatureProcessorFrequencyEncodingDeserializer);

    private DataframeAnalysisFeatureProcessorFrequencyEncoding(Builder builder) {
        this.featureName = ApiTypeHelper.requireNonNull(builder.featureName, this, "featureName");
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.frequencyMap = ApiTypeHelper.unmodifiableRequired(builder.frequencyMap, (Object)this, "frequencyMap");
    }

    public static DataframeAnalysisFeatureProcessorFrequencyEncoding of(Function<Builder, ObjectBuilder<DataframeAnalysisFeatureProcessorFrequencyEncoding>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeAnalysisFeatureProcessor.Kind _dataframeAnalysisFeatureProcessorKind() {
        return DataframeAnalysisFeatureProcessor.Kind.FrequencyEncoding;
    }

    public final String featureName() {
        return this.featureName;
    }

    public final String field() {
        return this.field;
    }

    public final Map<String, Double> frequencyMap() {
        return this.frequencyMap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("feature_name");
        generator.write(this.featureName);
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.frequencyMap)) {
            generator.writeKey("frequency_map");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.frequencyMap.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().doubleValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataframeAnalysisFeatureProcessorFrequencyEncodingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::featureName, JsonpDeserializer.stringDeserializer(), "feature_name");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::frequencyMap, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "frequency_map");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalysisFeatureProcessorFrequencyEncoding> {
        private String featureName;
        private String field;
        private Map<String, Double> frequencyMap;

        public Builder() {
        }

        private Builder(DataframeAnalysisFeatureProcessorFrequencyEncoding instance) {
            this.featureName = instance.featureName;
            this.field = instance.field;
            this.frequencyMap = instance.frequencyMap;
        }

        public final Builder featureName(String value) {
            this.featureName = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder frequencyMap(Map<String, Double> map) {
            this.frequencyMap = Builder._mapPutAll(this.frequencyMap, map);
            return this;
        }

        public final Builder frequencyMap(String key, Double value) {
            this.frequencyMap = Builder._mapPut(this.frequencyMap, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalysisFeatureProcessorFrequencyEncoding build() {
            this._checkSingleUse();
            return new DataframeAnalysisFeatureProcessorFrequencyEncoding(this);
        }
    }
}

