/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.IndicesOptions;
import co.elastic.clients.elasticsearch._types.ScriptField;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.mapping.RuntimeField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch.ml.ChunkingConfig;
import co.elastic.clients.elasticsearch.ml.DatafeedAuthorization;
import co.elastic.clients.elasticsearch.ml.DelayedDataCheckConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Datafeed
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final DatafeedAuthorization authorization;
    @Nullable
    private final ChunkingConfig chunkingConfig;
    private final String datafeedId;
    @Nullable
    private final Time frequency;
    private final List<String> indices;
    private final List<String> indexes;
    private final String jobId;
    @Nullable
    private final Integer maxEmptySearches;
    private final Query query;
    @Nullable
    private final Time queryDelay;
    private final Map<String, ScriptField> scriptFields;
    @Nullable
    private final Integer scrollSize;
    private final DelayedDataCheckConfig delayedDataCheckConfig;
    private final Map<String, RuntimeField> runtimeMappings;
    @Nullable
    private final IndicesOptions indicesOptions;
    public static final JsonpDeserializer<Datafeed> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Datafeed::setupDatafeedDeserializer);

    private Datafeed(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.authorization = builder.authorization;
        this.chunkingConfig = builder.chunkingConfig;
        this.datafeedId = ApiTypeHelper.requireNonNull(builder.datafeedId, this, "datafeedId");
        this.frequency = builder.frequency;
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
        this.indexes = ApiTypeHelper.unmodifiable(builder.indexes);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.maxEmptySearches = builder.maxEmptySearches;
        this.query = ApiTypeHelper.requireNonNull(builder.query, this, "query");
        this.queryDelay = builder.queryDelay;
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
        this.scrollSize = builder.scrollSize;
        this.delayedDataCheckConfig = ApiTypeHelper.requireNonNull(builder.delayedDataCheckConfig, this, "delayedDataCheckConfig");
        this.runtimeMappings = ApiTypeHelper.unmodifiable(builder.runtimeMappings);
        this.indicesOptions = builder.indicesOptions;
    }

    public static Datafeed of(Function<Builder, ObjectBuilder<Datafeed>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final DatafeedAuthorization authorization() {
        return this.authorization;
    }

    @Nullable
    public final ChunkingConfig chunkingConfig() {
        return this.chunkingConfig;
    }

    public final String datafeedId() {
        return this.datafeedId;
    }

    @Nullable
    public final Time frequency() {
        return this.frequency;
    }

    public final List<String> indices() {
        return this.indices;
    }

    public final List<String> indexes() {
        return this.indexes;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final Integer maxEmptySearches() {
        return this.maxEmptySearches;
    }

    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Time queryDelay() {
        return this.queryDelay;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Nullable
    public final Integer scrollSize() {
        return this.scrollSize;
    }

    public final DelayedDataCheckConfig delayedDataCheckConfig() {
        return this.delayedDataCheckConfig;
    }

    public final Map<String, RuntimeField> runtimeMappings() {
        return this.runtimeMappings;
    }

    @Nullable
    public final IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.authorization != null) {
            generator.writeKey("authorization");
            this.authorization.serialize(generator, mapper);
        }
        if (this.chunkingConfig != null) {
            generator.writeKey("chunking_config");
            this.chunkingConfig.serialize(generator, mapper);
        }
        generator.writeKey("datafeed_id");
        generator.write(this.datafeedId);
        if (this.frequency != null) {
            generator.writeKey("frequency");
            this.frequency.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (String string : this.indices) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.indexes)) {
            generator.writeKey("indexes");
            generator.writeStartArray();
            for (String string : this.indexes) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.maxEmptySearches != null) {
            generator.writeKey("max_empty_searches");
            generator.write(this.maxEmptySearches.intValue());
        }
        generator.writeKey("query");
        this.query.serialize(generator, mapper);
        if (this.queryDelay != null) {
            generator.writeKey("query_delay");
            this.queryDelay.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.scrollSize != null) {
            generator.writeKey("scroll_size");
            generator.write(this.scrollSize.intValue());
        }
        generator.writeKey("delayed_data_check_config");
        this.delayedDataCheckConfig.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.runtimeMappings)) {
            generator.writeKey("runtime_mappings");
            generator.writeStartObject();
            for (Map.Entry entry : this.runtimeMappings.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((RuntimeField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.indicesOptions != null) {
            generator.writeKey("indices_options");
            this.indicesOptions.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDatafeedDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::authorization, DatafeedAuthorization._DESERIALIZER, "authorization");
        op.add(Builder::chunkingConfig, ChunkingConfig._DESERIALIZER, "chunking_config");
        op.add(Builder::datafeedId, JsonpDeserializer.stringDeserializer(), "datafeed_id");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices");
        op.add(Builder::indexes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indexes");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::maxEmptySearches, JsonpDeserializer.integerDeserializer(), "max_empty_searches");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::queryDelay, Time._DESERIALIZER, "query_delay");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
        op.add(Builder::scrollSize, JsonpDeserializer.integerDeserializer(), "scroll_size");
        op.add(Builder::delayedDataCheckConfig, DelayedDataCheckConfig._DESERIALIZER, "delayed_data_check_config");
        op.add(Builder::runtimeMappings, JsonpDeserializer.stringMapDeserializer(RuntimeField._DESERIALIZER), "runtime_mappings");
        op.add(Builder::indicesOptions, IndicesOptions._DESERIALIZER, "indices_options");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Datafeed> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private DatafeedAuthorization authorization;
        @Nullable
        private ChunkingConfig chunkingConfig;
        private String datafeedId;
        @Nullable
        private Time frequency;
        private List<String> indices;
        @Nullable
        private List<String> indexes;
        private String jobId;
        @Nullable
        private Integer maxEmptySearches;
        private Query query;
        @Nullable
        private Time queryDelay;
        @Nullable
        private Map<String, ScriptField> scriptFields;
        @Nullable
        private Integer scrollSize;
        private DelayedDataCheckConfig delayedDataCheckConfig;
        @Nullable
        private Map<String, RuntimeField> runtimeMappings;
        @Nullable
        private IndicesOptions indicesOptions;

        public Builder() {
        }

        private Builder(Datafeed instance) {
            this.aggregations = instance.aggregations;
            this.authorization = instance.authorization;
            this.chunkingConfig = instance.chunkingConfig;
            this.datafeedId = instance.datafeedId;
            this.frequency = instance.frequency;
            this.indices = instance.indices;
            this.indexes = instance.indexes;
            this.jobId = instance.jobId;
            this.maxEmptySearches = instance.maxEmptySearches;
            this.query = instance.query;
            this.queryDelay = instance.queryDelay;
            this.scriptFields = instance.scriptFields;
            this.scrollSize = instance.scrollSize;
            this.delayedDataCheckConfig = instance.delayedDataCheckConfig;
            this.runtimeMappings = instance.runtimeMappings;
            this.indicesOptions = instance.indicesOptions;
        }

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, AggregationVariant value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value._toAggregation());
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder authorization(@Nullable DatafeedAuthorization value) {
            this.authorization = value;
            return this;
        }

        public final Builder authorization(Function<DatafeedAuthorization.Builder, ObjectBuilder<DatafeedAuthorization>> fn) {
            return this.authorization(fn.apply(new DatafeedAuthorization.Builder()).build());
        }

        public final Builder chunkingConfig(@Nullable ChunkingConfig value) {
            this.chunkingConfig = value;
            return this;
        }

        public final Builder chunkingConfig(Function<ChunkingConfig.Builder, ObjectBuilder<ChunkingConfig>> fn) {
            return this.chunkingConfig(fn.apply(new ChunkingConfig.Builder()).build());
        }

        public final Builder datafeedId(String value) {
            this.datafeedId = value;
            return this;
        }

        public final Builder frequency(@Nullable Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder indices(List<String> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(String value, String ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indexes(List<String> list) {
            this.indexes = Builder._listAddAll(this.indexes, list);
            return this;
        }

        public final Builder indexes(String value, String ... values) {
            this.indexes = Builder._listAdd(this.indexes, value, values);
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder maxEmptySearches(@Nullable Integer value) {
            this.maxEmptySearches = value;
            return this;
        }

        public final Builder query(Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder query(QueryVariant value) {
            this.query = value._toQuery();
            return this;
        }

        public final Builder queryDelay(@Nullable Time value) {
            this.queryDelay = value;
            return this;
        }

        public final Builder queryDelay(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.queryDelay(fn.apply(new Time.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        public final Builder scrollSize(@Nullable Integer value) {
            this.scrollSize = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(DelayedDataCheckConfig value) {
            this.delayedDataCheckConfig = value;
            return this;
        }

        public final Builder delayedDataCheckConfig(Function<DelayedDataCheckConfig.Builder, ObjectBuilder<DelayedDataCheckConfig>> fn) {
            return this.delayedDataCheckConfig(fn.apply(new DelayedDataCheckConfig.Builder()).build());
        }

        public final Builder runtimeMappings(Map<String, RuntimeField> map) {
            this.runtimeMappings = Builder._mapPutAll(this.runtimeMappings, map);
            return this;
        }

        public final Builder runtimeMappings(String key, RuntimeField value) {
            this.runtimeMappings = Builder._mapPut(this.runtimeMappings, key, value);
            return this;
        }

        public final Builder runtimeMappings(String key, Function<RuntimeField.Builder, ObjectBuilder<RuntimeField>> fn) {
            return this.runtimeMappings(key, fn.apply(new RuntimeField.Builder()).build());
        }

        public final Builder indicesOptions(@Nullable IndicesOptions value) {
            this.indicesOptions = value;
            return this;
        }

        public final Builder indicesOptions(Function<IndicesOptions.Builder, ObjectBuilder<IndicesOptions>> fn) {
            return this.indicesOptions(fn.apply(new IndicesOptions.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Datafeed build() {
            this._checkSingleUse();
            return new Datafeed(this);
        }
    }
}

