/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CalendarEvent
implements JsonpSerializable {
    @Nullable
    private final String calendarId;
    @Nullable
    private final String eventId;
    private final String description;
    private final DateTime endTime;
    private final DateTime startTime;
    public static final JsonpDeserializer<CalendarEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CalendarEvent::setupCalendarEventDeserializer);

    private CalendarEvent(Builder builder) {
        this.calendarId = builder.calendarId;
        this.eventId = builder.eventId;
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.endTime = ApiTypeHelper.requireNonNull(builder.endTime, this, "endTime");
        this.startTime = ApiTypeHelper.requireNonNull(builder.startTime, this, "startTime");
    }

    public static CalendarEvent of(Function<Builder, ObjectBuilder<CalendarEvent>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String calendarId() {
        return this.calendarId;
    }

    @Nullable
    public final String eventId() {
        return this.eventId;
    }

    public final String description() {
        return this.description;
    }

    public final DateTime endTime() {
        return this.endTime;
    }

    public final DateTime startTime() {
        return this.startTime;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.calendarId != null) {
            generator.writeKey("calendar_id");
            generator.write(this.calendarId);
        }
        if (this.eventId != null) {
            generator.writeKey("event_id");
            generator.write(this.eventId);
        }
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("end_time");
        this.endTime.serialize(generator, mapper);
        generator.writeKey("start_time");
        this.startTime.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCalendarEventDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::calendarId, JsonpDeserializer.stringDeserializer(), "calendar_id");
        op.add(Builder::eventId, JsonpDeserializer.stringDeserializer(), "event_id");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::endTime, DateTime._DESERIALIZER, "end_time");
        op.add(Builder::startTime, DateTime._DESERIALIZER, "start_time");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CalendarEvent> {
        @Nullable
        private String calendarId;
        @Nullable
        private String eventId;
        private String description;
        private DateTime endTime;
        private DateTime startTime;

        public Builder() {
        }

        private Builder(CalendarEvent instance) {
            this.calendarId = instance.calendarId;
            this.eventId = instance.eventId;
            this.description = instance.description;
            this.endTime = instance.endTime;
            this.startTime = instance.startTime;
        }

        public final Builder calendarId(@Nullable String value) {
            this.calendarId = value;
            return this;
        }

        public final Builder eventId(@Nullable String value) {
            this.eventId = value;
            return this;
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder endTime(DateTime value) {
            this.endTime = value;
            return this;
        }

        public final Builder startTime(DateTime value) {
            this.startTime = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CalendarEvent build() {
            this._checkSingleUse();
            return new CalendarEvent(this);
        }
    }
}

