/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.BucketInfluencer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class BucketSummary
implements JsonpSerializable {
    private final double anomalyScore;
    private final List<BucketInfluencer> bucketInfluencers;
    private final long bucketSpan;
    private final long eventCount;
    private final double initialAnomalyScore;
    private final boolean isInterim;
    private final String jobId;
    private final long processingTimeMs;
    private final String resultType;
    private final long timestamp;
    @Nullable
    private final DateTime timestampString;
    public static final JsonpDeserializer<BucketSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketSummary::setupBucketSummaryDeserializer);

    private BucketSummary(Builder builder) {
        this.anomalyScore = ApiTypeHelper.requireNonNull(builder.anomalyScore, (Object)this, "anomalyScore", 0.0);
        this.bucketInfluencers = ApiTypeHelper.unmodifiableRequired(builder.bucketInfluencers, (Object)this, "bucketInfluencers");
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, (Object)this, "bucketSpan", 0L);
        this.eventCount = ApiTypeHelper.requireNonNull(builder.eventCount, (Object)this, "eventCount", 0L);
        this.initialAnomalyScore = ApiTypeHelper.requireNonNull(builder.initialAnomalyScore, (Object)this, "initialAnomalyScore", 0.0);
        this.isInterim = ApiTypeHelper.requireNonNull(builder.isInterim, (Object)this, "isInterim", false);
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.processingTimeMs = ApiTypeHelper.requireNonNull(builder.processingTimeMs, (Object)this, "processingTimeMs", 0L);
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, (Object)this, "timestamp", 0L);
        this.timestampString = builder.timestampString;
    }

    public static BucketSummary of(Function<Builder, ObjectBuilder<BucketSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final double anomalyScore() {
        return this.anomalyScore;
    }

    public final List<BucketInfluencer> bucketInfluencers() {
        return this.bucketInfluencers;
    }

    public final long bucketSpan() {
        return this.bucketSpan;
    }

    public final long eventCount() {
        return this.eventCount;
    }

    public final double initialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    public final boolean isInterim() {
        return this.isInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final long processingTimeMs() {
        return this.processingTimeMs;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Nullable
    public final DateTime timestampString() {
        return this.timestampString;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("anomaly_score");
        generator.write(this.anomalyScore);
        if (ApiTypeHelper.isDefined(this.bucketInfluencers)) {
            generator.writeKey("bucket_influencers");
            generator.writeStartArray();
            for (BucketInfluencer item0 : this.bucketInfluencers) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        generator.writeKey("event_count");
        generator.write(this.eventCount);
        generator.writeKey("initial_anomaly_score");
        generator.write(this.initialAnomalyScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        generator.writeKey("processing_time_ms");
        generator.write(this.processingTimeMs);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (this.timestampString != null) {
            generator.writeKey("timestamp_string");
            this.timestampString.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupBucketSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::anomalyScore, JsonpDeserializer.doubleDeserializer(), "anomaly_score");
        op.add(Builder::bucketInfluencers, JsonpDeserializer.arrayDeserializer(BucketInfluencer._DESERIALIZER), "bucket_influencers");
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span");
        op.add(Builder::eventCount, JsonpDeserializer.longDeserializer(), "event_count");
        op.add(Builder::initialAnomalyScore, JsonpDeserializer.doubleDeserializer(), "initial_anomaly_score");
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::processingTimeMs, JsonpDeserializer.longDeserializer(), "processing_time_ms");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::timestampString, DateTime._DESERIALIZER, "timestamp_string");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<BucketSummary> {
        private Double anomalyScore;
        private List<BucketInfluencer> bucketInfluencers;
        private Long bucketSpan;
        private Long eventCount;
        private Double initialAnomalyScore;
        private Boolean isInterim;
        private String jobId;
        private Long processingTimeMs;
        private String resultType;
        private Long timestamp;
        @Nullable
        private DateTime timestampString;

        public Builder() {
        }

        private Builder(BucketSummary instance) {
            this.anomalyScore = instance.anomalyScore;
            this.bucketInfluencers = instance.bucketInfluencers;
            this.bucketSpan = instance.bucketSpan;
            this.eventCount = instance.eventCount;
            this.initialAnomalyScore = instance.initialAnomalyScore;
            this.isInterim = instance.isInterim;
            this.jobId = instance.jobId;
            this.processingTimeMs = instance.processingTimeMs;
            this.resultType = instance.resultType;
            this.timestamp = instance.timestamp;
            this.timestampString = instance.timestampString;
        }

        public final Builder anomalyScore(double value) {
            this.anomalyScore = value;
            return this;
        }

        public final Builder bucketInfluencers(List<BucketInfluencer> list) {
            this.bucketInfluencers = Builder._listAddAll(this.bucketInfluencers, list);
            return this;
        }

        public final Builder bucketInfluencers(BucketInfluencer value, BucketInfluencer ... values) {
            this.bucketInfluencers = Builder._listAdd(this.bucketInfluencers, value, values);
            return this;
        }

        public final Builder bucketInfluencers(Function<BucketInfluencer.Builder, ObjectBuilder<BucketInfluencer>> fn) {
            return this.bucketInfluencers(fn.apply(new BucketInfluencer.Builder()).build(), new BucketInfluencer[0]);
        }

        public final Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder eventCount(long value) {
            this.eventCount = value;
            return this;
        }

        public final Builder initialAnomalyScore(double value) {
            this.initialAnomalyScore = value;
            return this;
        }

        public final Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder processingTimeMs(long value) {
            this.processingTimeMs = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timestampString(@Nullable DateTime value) {
            this.timestampString = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketSummary build() {
            this._checkSingleUse();
            return new BucketSummary(this);
        }
    }
}

