/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AdaptiveAllocationsSettings
implements JsonpSerializable {
    private final boolean enabled;
    @Nullable
    private final Integer minNumberOfAllocations;
    @Nullable
    private final Integer maxNumberOfAllocations;
    public static final JsonpDeserializer<AdaptiveAllocationsSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdaptiveAllocationsSettings::setupAdaptiveAllocationsSettingsDeserializer);

    private AdaptiveAllocationsSettings(Builder builder) {
        this.enabled = ApiTypeHelper.requireNonNull(builder.enabled, (Object)this, "enabled", false);
        this.minNumberOfAllocations = builder.minNumberOfAllocations;
        this.maxNumberOfAllocations = builder.maxNumberOfAllocations;
    }

    public static AdaptiveAllocationsSettings of(Function<Builder, ObjectBuilder<AdaptiveAllocationsSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Integer minNumberOfAllocations() {
        return this.minNumberOfAllocations;
    }

    @Nullable
    public final Integer maxNumberOfAllocations() {
        return this.maxNumberOfAllocations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("enabled");
        generator.write(this.enabled);
        if (this.minNumberOfAllocations != null) {
            generator.writeKey("min_number_of_allocations");
            generator.write(this.minNumberOfAllocations.intValue());
        }
        if (this.maxNumberOfAllocations != null) {
            generator.writeKey("max_number_of_allocations");
            generator.write(this.maxNumberOfAllocations.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAdaptiveAllocationsSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::minNumberOfAllocations, JsonpDeserializer.integerDeserializer(), "min_number_of_allocations");
        op.add(Builder::maxNumberOfAllocations, JsonpDeserializer.integerDeserializer(), "max_number_of_allocations");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AdaptiveAllocationsSettings> {
        private Boolean enabled;
        @Nullable
        private Integer minNumberOfAllocations;
        @Nullable
        private Integer maxNumberOfAllocations;

        public Builder() {
        }

        private Builder(AdaptiveAllocationsSettings instance) {
            this.enabled = instance.enabled;
            this.minNumberOfAllocations = instance.minNumberOfAllocations;
            this.maxNumberOfAllocations = instance.maxNumberOfAllocations;
        }

        public final Builder enabled(boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder minNumberOfAllocations(@Nullable Integer value) {
            this.minNumberOfAllocations = value;
            return this;
        }

        public final Builder maxNumberOfAllocations(@Nullable Integer value) {
            this.maxNumberOfAllocations = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdaptiveAllocationsSettings build() {
            this._checkSingleUse();
            return new AdaptiveAllocationsSettings(this);
        }
    }
}

