/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RegisteredDomainProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final String targetField;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<RegisteredDomainProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RegisteredDomainProcessor::setupRegisteredDomainProcessorDeserializer);

    private RegisteredDomainProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.targetField = builder.targetField;
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static RegisteredDomainProcessor of(Function<Builder, ObjectBuilder<RegisteredDomainProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.RegisteredDomain;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRegisteredDomainProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RegisteredDomainProcessor> {
        private String field;
        @Nullable
        private String targetField;
        @Nullable
        private Boolean ignoreMissing;

        public Builder() {
        }

        private Builder(RegisteredDomainProcessor instance) {
            this.field = instance.field;
            this.targetField = instance.targetField;
            this.ignoreMissing = instance.ignoreMissing;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RegisteredDomainProcessor build() {
            this._checkSingleUse();
            return new RegisteredDomainProcessor(this);
        }
    }
}

