/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.ingest.DocumentSimulation;
import co.elastic.clients.elasticsearch.ingest.PipelineSimulationStatusOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PipelineProcessorResult
implements JsonpSerializable {
    @Nullable
    private final DocumentSimulation doc;
    @Nullable
    private final String tag;
    @Nullable
    private final String processorType;
    @Nullable
    private final PipelineSimulationStatusOptions status;
    @Nullable
    private final String description;
    @Nullable
    private final ErrorCause ignoredError;
    @Nullable
    private final ErrorCause error;
    public static final JsonpDeserializer<PipelineProcessorResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PipelineProcessorResult::setupPipelineProcessorResultDeserializer);

    private PipelineProcessorResult(Builder builder) {
        this.doc = builder.doc;
        this.tag = builder.tag;
        this.processorType = builder.processorType;
        this.status = builder.status;
        this.description = builder.description;
        this.ignoredError = builder.ignoredError;
        this.error = builder.error;
    }

    public static PipelineProcessorResult of(Function<Builder, ObjectBuilder<PipelineProcessorResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DocumentSimulation doc() {
        return this.doc;
    }

    @Nullable
    public final String tag() {
        return this.tag;
    }

    @Nullable
    public final String processorType() {
        return this.processorType;
    }

    @Nullable
    public final PipelineSimulationStatusOptions status() {
        return this.status;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final ErrorCause ignoredError() {
        return this.ignoredError;
    }

    @Nullable
    public final ErrorCause error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (this.tag != null) {
            generator.writeKey("tag");
            generator.write(this.tag);
        }
        if (this.processorType != null) {
            generator.writeKey("processor_type");
            generator.write(this.processorType);
        }
        if (this.status != null) {
            generator.writeKey("status");
            this.status.serialize(generator, mapper);
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.ignoredError != null) {
            generator.writeKey("ignored_error");
            this.ignoredError.serialize(generator, mapper);
        }
        if (this.error != null) {
            generator.writeKey("error");
            this.error.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPipelineProcessorResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, DocumentSimulation._DESERIALIZER, "doc");
        op.add(Builder::tag, JsonpDeserializer.stringDeserializer(), "tag");
        op.add(Builder::processorType, JsonpDeserializer.stringDeserializer(), "processor_type");
        op.add(Builder::status, PipelineSimulationStatusOptions._DESERIALIZER, "status");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::ignoredError, ErrorCause._DESERIALIZER, "ignored_error");
        op.add(Builder::error, ErrorCause._DESERIALIZER, "error");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PipelineProcessorResult> {
        @Nullable
        private DocumentSimulation doc;
        @Nullable
        private String tag;
        @Nullable
        private String processorType;
        @Nullable
        private PipelineSimulationStatusOptions status;
        @Nullable
        private String description;
        @Nullable
        private ErrorCause ignoredError;
        @Nullable
        private ErrorCause error;

        public Builder() {
        }

        private Builder(PipelineProcessorResult instance) {
            this.doc = instance.doc;
            this.tag = instance.tag;
            this.processorType = instance.processorType;
            this.status = instance.status;
            this.description = instance.description;
            this.ignoredError = instance.ignoredError;
            this.error = instance.error;
        }

        public final Builder doc(@Nullable DocumentSimulation value) {
            this.doc = value;
            return this;
        }

        public final Builder doc(Function<DocumentSimulation.Builder, ObjectBuilder<DocumentSimulation>> fn) {
            return this.doc(fn.apply(new DocumentSimulation.Builder()).build());
        }

        public final Builder tag(@Nullable String value) {
            this.tag = value;
            return this;
        }

        public final Builder processorType(@Nullable String value) {
            this.processorType = value;
            return this;
        }

        public final Builder status(@Nullable PipelineSimulationStatusOptions value) {
            this.status = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder ignoredError(@Nullable ErrorCause value) {
            this.ignoredError = value;
            return this;
        }

        public final Builder ignoredError(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.ignoredError(fn.apply(new ErrorCause.Builder()).build());
        }

        public final Builder error(@Nullable ErrorCause value) {
            this.error = value;
            return this;
        }

        public final Builder error(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.error(fn.apply(new ErrorCause.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PipelineProcessorResult build() {
            this._checkSingleUse();
            return new PipelineProcessorResult(this);
        }
    }
}

