/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.ToolCallFunction;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ToolCall
implements JsonpSerializable {
    private final String id;
    private final ToolCallFunction function;
    private final String type;
    public static final JsonpDeserializer<ToolCall> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ToolCall::setupToolCallDeserializer);

    private ToolCall(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.function = ApiTypeHelper.requireNonNull(builder.function, this, "function");
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
    }

    public static ToolCall of(Function<Builder, ObjectBuilder<ToolCall>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String id() {
        return this.id;
    }

    public final ToolCallFunction function() {
        return this.function;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("function");
        this.function.serialize(generator, mapper);
        generator.writeKey("type");
        generator.write(this.type);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupToolCallDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::function, ToolCallFunction._DESERIALIZER, "function");
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ToolCall> {
        private String id;
        private ToolCallFunction function;
        private String type;

        public Builder() {
        }

        private Builder(ToolCall instance) {
            this.id = instance.id;
            this.function = instance.function;
            this.type = instance.type;
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder function(ToolCallFunction value) {
            this.function = value;
            return this;
        }

        public final Builder function(Function<ToolCallFunction.Builder, ObjectBuilder<ToolCallFunction>> fn) {
            return this.function(fn.apply(new ToolCallFunction.Builder()).build());
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ToolCall build() {
            this._checkSingleUse();
            return new ToolCall(this);
        }
    }
}

