/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.JinaAIServiceSettings;
import co.elastic.clients.elasticsearch.inference.JinaAIServiceType;
import co.elastic.clients.elasticsearch.inference.JinaAITaskSettings;
import co.elastic.clients.elasticsearch.inference.JinaAITaskType;
import co.elastic.clients.elasticsearch.inference.PutJinaaiResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutJinaaiRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final String jinaaiInferenceId;
    private final JinaAIServiceType service;
    private final JinaAIServiceSettings serviceSettings;
    @Nullable
    private final JinaAITaskSettings taskSettings;
    private final JinaAITaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutJinaaiRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutJinaaiRequest::setupPutJinaaiRequestDeserializer);
    public static final Endpoint<PutJinaaiRequest, PutJinaaiResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutJinaaiRequest, PutJinaaiResponse>("es/inference.put_jinaai", request -> "PUT", request -> {
        boolean _jinaaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jinaaiInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jinaaiInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("jinaaiInferenceId", request.jinaaiInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutJinaaiResponse._DESERIALIZER);

    private PutJinaaiRequest(Builder builder) {
        this.chunkingSettings = builder.chunkingSettings;
        this.jinaaiInferenceId = ApiTypeHelper.requireNonNull(builder.jinaaiInferenceId, this, "jinaaiInferenceId");
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutJinaaiRequest of(Function<Builder, ObjectBuilder<PutJinaaiRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final String jinaaiInferenceId() {
        return this.jinaaiInferenceId;
    }

    public final JinaAIServiceType service() {
        return this.service;
    }

    public final JinaAIServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final JinaAITaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final JinaAITaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutJinaaiRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, JinaAIServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, JinaAIServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, JinaAITaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutJinaaiRequest> {
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private String jinaaiInferenceId;
        private JinaAIServiceType service;
        private JinaAIServiceSettings serviceSettings;
        @Nullable
        private JinaAITaskSettings taskSettings;
        private JinaAITaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutJinaaiRequest instance) {
            this.chunkingSettings = instance.chunkingSettings;
            this.jinaaiInferenceId = instance.jinaaiInferenceId;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder jinaaiInferenceId(String value) {
            this.jinaaiInferenceId = value;
            return this;
        }

        public final Builder service(JinaAIServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(JinaAIServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<JinaAIServiceSettings.Builder, ObjectBuilder<JinaAIServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new JinaAIServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable JinaAITaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<JinaAITaskSettings.Builder, ObjectBuilder<JinaAITaskSettings>> fn) {
            return this.taskSettings(fn.apply(new JinaAITaskSettings.Builder()).build());
        }

        public final Builder taskType(JinaAITaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutJinaaiRequest build() {
            this._checkSingleUse();
            return new PutJinaaiRequest(this);
        }
    }
}

