/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.AmazonBedrockServiceSettings;
import co.elastic.clients.elasticsearch.inference.AmazonBedrockServiceType;
import co.elastic.clients.elasticsearch.inference.AmazonBedrockTaskSettings;
import co.elastic.clients.elasticsearch.inference.AmazonBedrockTaskType;
import co.elastic.clients.elasticsearch.inference.InferenceChunkingSettings;
import co.elastic.clients.elasticsearch.inference.PutAmazonbedrockResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PutAmazonbedrockRequest
extends RequestBase
implements JsonpSerializable {
    private final String amazonbedrockInferenceId;
    @Nullable
    private final InferenceChunkingSettings chunkingSettings;
    private final AmazonBedrockServiceType service;
    private final AmazonBedrockServiceSettings serviceSettings;
    @Nullable
    private final AmazonBedrockTaskSettings taskSettings;
    private final AmazonBedrockTaskType taskType;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<PutAmazonbedrockRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutAmazonbedrockRequest::setupPutAmazonbedrockRequestDeserializer);
    public static final Endpoint<PutAmazonbedrockRequest, PutAmazonbedrockResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PutAmazonbedrockRequest, PutAmazonbedrockResponse>("es/inference.put_amazonbedrock", request -> "PUT", request -> {
        boolean _amazonbedrockInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.amazonbedrockInferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _amazonbedrockInferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("amazonbedrockInferenceId", request.amazonbedrockInferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, PutAmazonbedrockResponse._DESERIALIZER);

    private PutAmazonbedrockRequest(Builder builder) {
        this.amazonbedrockInferenceId = ApiTypeHelper.requireNonNull(builder.amazonbedrockInferenceId, this, "amazonbedrockInferenceId");
        this.chunkingSettings = builder.chunkingSettings;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
        this.serviceSettings = ApiTypeHelper.requireNonNull(builder.serviceSettings, this, "serviceSettings");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
        this.timeout = builder.timeout;
    }

    public static PutAmazonbedrockRequest of(Function<Builder, ObjectBuilder<PutAmazonbedrockRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String amazonbedrockInferenceId() {
        return this.amazonbedrockInferenceId;
    }

    @Nullable
    public final InferenceChunkingSettings chunkingSettings() {
        return this.chunkingSettings;
    }

    public final AmazonBedrockServiceType service() {
        return this.service;
    }

    public final AmazonBedrockServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Nullable
    public final AmazonBedrockTaskSettings taskSettings() {
        return this.taskSettings;
    }

    public final AmazonBedrockTaskType taskType() {
        return this.taskType;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkingSettings != null) {
            generator.writeKey("chunking_settings");
            this.chunkingSettings.serialize(generator, mapper);
        }
        generator.writeKey("service");
        this.service.serialize(generator, mapper);
        generator.writeKey("service_settings");
        this.serviceSettings.serialize(generator, mapper);
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPutAmazonbedrockRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkingSettings, InferenceChunkingSettings._DESERIALIZER, "chunking_settings");
        op.add(Builder::service, AmazonBedrockServiceType._DESERIALIZER, "service");
        op.add(Builder::serviceSettings, AmazonBedrockServiceSettings._DESERIALIZER, "service_settings");
        op.add(Builder::taskSettings, AmazonBedrockTaskSettings._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PutAmazonbedrockRequest> {
        private String amazonbedrockInferenceId;
        @Nullable
        private InferenceChunkingSettings chunkingSettings;
        private AmazonBedrockServiceType service;
        private AmazonBedrockServiceSettings serviceSettings;
        @Nullable
        private AmazonBedrockTaskSettings taskSettings;
        private AmazonBedrockTaskType taskType;
        @Nullable
        private Time timeout;

        public Builder() {
        }

        private Builder(PutAmazonbedrockRequest instance) {
            this.amazonbedrockInferenceId = instance.amazonbedrockInferenceId;
            this.chunkingSettings = instance.chunkingSettings;
            this.service = instance.service;
            this.serviceSettings = instance.serviceSettings;
            this.taskSettings = instance.taskSettings;
            this.taskType = instance.taskType;
            this.timeout = instance.timeout;
        }

        public final Builder amazonbedrockInferenceId(String value) {
            this.amazonbedrockInferenceId = value;
            return this;
        }

        public final Builder chunkingSettings(@Nullable InferenceChunkingSettings value) {
            this.chunkingSettings = value;
            return this;
        }

        public final Builder chunkingSettings(Function<InferenceChunkingSettings.Builder, ObjectBuilder<InferenceChunkingSettings>> fn) {
            return this.chunkingSettings(fn.apply(new InferenceChunkingSettings.Builder()).build());
        }

        public final Builder service(AmazonBedrockServiceType value) {
            this.service = value;
            return this;
        }

        public final Builder serviceSettings(AmazonBedrockServiceSettings value) {
            this.serviceSettings = value;
            return this;
        }

        public final Builder serviceSettings(Function<AmazonBedrockServiceSettings.Builder, ObjectBuilder<AmazonBedrockServiceSettings>> fn) {
            return this.serviceSettings(fn.apply(new AmazonBedrockServiceSettings.Builder()).build());
        }

        public final Builder taskSettings(@Nullable AmazonBedrockTaskSettings value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskSettings(Function<AmazonBedrockTaskSettings.Builder, ObjectBuilder<AmazonBedrockTaskSettings>> fn) {
            return this.taskSettings(fn.apply(new AmazonBedrockTaskSettings.Builder()).build());
        }

        public final Builder taskType(AmazonBedrockTaskType value) {
            this.taskType = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PutAmazonbedrockRequest build() {
            this._checkSingleUse();
            return new PutAmazonbedrockRequest(this);
        }
    }
}

