/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class GoogleVertexAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final Boolean autoTruncate;
    @Nullable
    private final Integer topN;
    public static final JsonpDeserializer<GoogleVertexAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GoogleVertexAITaskSettings::setupGoogleVertexAITaskSettingsDeserializer);

    private GoogleVertexAITaskSettings(Builder builder) {
        this.autoTruncate = builder.autoTruncate;
        this.topN = builder.topN;
    }

    public static GoogleVertexAITaskSettings of(Function<Builder, ObjectBuilder<GoogleVertexAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean autoTruncate() {
        return this.autoTruncate;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.autoTruncate != null) {
            generator.writeKey("auto_truncate");
            generator.write(this.autoTruncate.booleanValue());
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupGoogleVertexAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::autoTruncate, JsonpDeserializer.booleanDeserializer(), "auto_truncate");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GoogleVertexAITaskSettings> {
        @Nullable
        private Boolean autoTruncate;
        @Nullable
        private Integer topN;

        public Builder() {
        }

        private Builder(GoogleVertexAITaskSettings instance) {
            this.autoTruncate = instance.autoTruncate;
            this.topN = instance.topN;
        }

        public final Builder autoTruncate(@Nullable Boolean value) {
            this.autoTruncate = value;
            return this;
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GoogleVertexAITaskSettings build() {
            this._checkSingleUse();
            return new GoogleVertexAITaskSettings(this);
        }
    }
}

