/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.DeleteInferenceResponse;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class DeleteInferenceRequest
extends RequestBase {
    @Nullable
    private final Boolean dryRun;
    @Nullable
    private final Boolean force;
    private final String inferenceId;
    @Nullable
    private final TaskType taskType;
    public static final Endpoint<DeleteInferenceRequest, DeleteInferenceResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<DeleteInferenceRequest, DeleteInferenceResponse>("es/inference.delete", request -> "DELETE", request -> {
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.taskType() != null) {
            propsSet |= 2;
        }
        if (propsSet == 1) {
            params.put("inferenceId", request.inferenceId);
        }
        if (propsSet == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.dryRun != null) {
            params.put("dry_run", String.valueOf(request.dryRun));
        }
        if (request.force != null) {
            params.put("force", String.valueOf(request.force));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteInferenceResponse._DESERIALIZER);

    private DeleteInferenceRequest(Builder builder) {
        this.dryRun = builder.dryRun;
        this.force = builder.force;
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.taskType = builder.taskType;
    }

    public static DeleteInferenceRequest of(Function<Builder, ObjectBuilder<DeleteInferenceRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Nullable
    public final Boolean force() {
        return this.force;
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    @Nullable
    public final TaskType taskType() {
        return this.taskType;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<DeleteInferenceRequest> {
        @Nullable
        private Boolean dryRun;
        @Nullable
        private Boolean force;
        private String inferenceId;
        @Nullable
        private TaskType taskType;

        public Builder() {
        }

        private Builder(DeleteInferenceRequest instance) {
            this.dryRun = instance.dryRun;
            this.force = instance.force;
            this.inferenceId = instance.inferenceId;
            this.taskType = instance.taskType;
        }

        public final Builder dryRun(@Nullable Boolean value) {
            this.dryRun = value;
            return this;
        }

        public final Builder force(@Nullable Boolean value) {
            this.force = value;
            return this;
        }

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder taskType(@Nullable TaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DeleteInferenceRequest build() {
            this._checkSingleUse();
            return new DeleteInferenceRequest(this);
        }
    }
}

