/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CompletionToolFunction
implements JsonpSerializable {
    @Nullable
    private final String description;
    private final String name;
    @Nullable
    private final JsonData parameters;
    @Nullable
    private final Boolean strict;
    public static final JsonpDeserializer<CompletionToolFunction> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CompletionToolFunction::setupCompletionToolFunctionDeserializer);

    private CompletionToolFunction(Builder builder) {
        this.description = builder.description;
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.parameters = builder.parameters;
        this.strict = builder.strict;
    }

    public static CompletionToolFunction of(Function<Builder, ObjectBuilder<CompletionToolFunction>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    @Nullable
    public final JsonData parameters() {
        return this.parameters;
    }

    @Nullable
    public final Boolean strict() {
        return this.strict;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.parameters != null) {
            generator.writeKey("parameters");
            this.parameters.serialize(generator, mapper);
        }
        if (this.strict != null) {
            generator.writeKey("strict");
            generator.write(this.strict.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupCompletionToolFunctionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::parameters, JsonData._DESERIALIZER, "parameters");
        op.add(Builder::strict, JsonpDeserializer.booleanDeserializer(), "strict");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CompletionToolFunction> {
        @Nullable
        private String description;
        private String name;
        @Nullable
        private JsonData parameters;
        @Nullable
        private Boolean strict;

        public Builder() {
        }

        private Builder(CompletionToolFunction instance) {
            this.description = instance.description;
            this.name = instance.name;
            this.parameters = instance.parameters;
            this.strict = instance.strict;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder parameters(@Nullable JsonData value) {
            this.parameters = value;
            return this;
        }

        public final Builder strict(@Nullable Boolean value) {
            this.strict = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CompletionToolFunction build() {
            this._checkSingleUse();
            return new CompletionToolFunction(this);
        }
    }
}

