/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.migrate_reindex;

import co.elastic.clients.elasticsearch.indices.migrate_reindex.ModeEnum;
import co.elastic.clients.elasticsearch.indices.migrate_reindex.SourceIndex;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MigrateReindex
implements JsonpSerializable {
    private final ModeEnum mode;
    private final SourceIndex source;
    public static final JsonpDeserializer<MigrateReindex> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MigrateReindex::setupMigrateReindexDeserializer);

    private MigrateReindex(Builder builder) {
        this.mode = ApiTypeHelper.requireNonNull(builder.mode, this, "mode");
        this.source = ApiTypeHelper.requireNonNull(builder.source, this, "source");
    }

    public static MigrateReindex of(Function<Builder, ObjectBuilder<MigrateReindex>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final ModeEnum mode() {
        return this.mode;
    }

    public final SourceIndex source() {
        return this.source;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("mode");
        this.mode.serialize(generator, mapper);
        generator.writeKey("source");
        this.source.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMigrateReindexDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, ModeEnum._DESERIALIZER, "mode");
        op.add(Builder::source, SourceIndex._DESERIALIZER, "source");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MigrateReindex> {
        private ModeEnum mode;
        private SourceIndex source;

        public Builder() {
        }

        private Builder(MigrateReindex instance) {
            this.mode = instance.mode;
            this.source = instance.source;
        }

        public final Builder mode(ModeEnum value) {
            this.mode = value;
            return this;
        }

        public final Builder source(SourceIndex value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceIndex.Builder, ObjectBuilder<SourceIndex>> fn) {
            return this.source(fn.apply(new SourceIndex.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MigrateReindex build() {
            this._checkSingleUse();
            return new MigrateReindex(this);
        }
    }
}

