/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_migrate_reindex_status;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class StatusInProgress
implements JsonpSerializable {
    private final String index;
    private final long totalDocCount;
    private final long reindexedDocCount;
    public static final JsonpDeserializer<StatusInProgress> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StatusInProgress::setupStatusInProgressDeserializer);

    private StatusInProgress(Builder builder) {
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.totalDocCount = ApiTypeHelper.requireNonNull(builder.totalDocCount, (Object)this, "totalDocCount", 0L);
        this.reindexedDocCount = ApiTypeHelper.requireNonNull(builder.reindexedDocCount, (Object)this, "reindexedDocCount", 0L);
    }

    public static StatusInProgress of(Function<Builder, ObjectBuilder<StatusInProgress>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String index() {
        return this.index;
    }

    public final long totalDocCount() {
        return this.totalDocCount;
    }

    public final long reindexedDocCount() {
        return this.reindexedDocCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("index");
        generator.write(this.index);
        generator.writeKey("total_doc_count");
        generator.write(this.totalDocCount);
        generator.writeKey("reindexed_doc_count");
        generator.write(this.reindexedDocCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupStatusInProgressDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::totalDocCount, JsonpDeserializer.longDeserializer(), "total_doc_count");
        op.add(Builder::reindexedDocCount, JsonpDeserializer.longDeserializer(), "reindexed_doc_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<StatusInProgress> {
        private String index;
        private Long totalDocCount;
        private Long reindexedDocCount;

        public Builder() {
        }

        private Builder(StatusInProgress instance) {
            this.index = instance.index;
            this.totalDocCount = instance.totalDocCount;
            this.reindexedDocCount = instance.reindexedDocCount;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder totalDocCount(long value) {
            this.totalDocCount = value;
            return this;
        }

        public final Builder reindexedDocCount(long value) {
            this.reindexedDocCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public StatusInProgress build() {
            this._checkSingleUse();
            return new StatusInProgress(this);
        }
    }
}

