/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.get_data_stream_settings;

import co.elastic.clients.elasticsearch.indices.IndexSettings;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataStreamSettings
implements JsonpSerializable {
    private final String name;
    private final IndexSettings settings;
    private final IndexSettings effectiveSettings;
    public static final JsonpDeserializer<DataStreamSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamSettings::setupDataStreamSettingsDeserializer);

    private DataStreamSettings(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.settings = ApiTypeHelper.requireNonNull(builder.settings, this, "settings");
        this.effectiveSettings = ApiTypeHelper.requireNonNull(builder.effectiveSettings, this, "effectiveSettings");
    }

    public static DataStreamSettings of(Function<Builder, ObjectBuilder<DataStreamSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final IndexSettings settings() {
        return this.settings;
    }

    public final IndexSettings effectiveSettings() {
        return this.effectiveSettings;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("settings");
        this.settings.serialize(generator, mapper);
        generator.writeKey("effective_settings");
        this.effectiveSettings.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataStreamSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::settings, IndexSettings._DESERIALIZER, "settings");
        op.add(Builder::effectiveSettings, IndexSettings._DESERIALIZER, "effective_settings");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamSettings> {
        private String name;
        private IndexSettings settings;
        private IndexSettings effectiveSettings;

        public Builder() {
        }

        private Builder(DataStreamSettings instance) {
            this.name = instance.name;
            this.settings = instance.settings;
            this.effectiveSettings = instance.effectiveSettings;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder settings(IndexSettings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(fn.apply(new IndexSettings.Builder()).build());
        }

        public final Builder effectiveSettings(IndexSettings value) {
            this.effectiveSettings = value;
            return this;
        }

        public final Builder effectiveSettings(Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.effectiveSettings(fn.apply(new IndexSettings.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamSettings build() {
            this._checkSingleUse();
            return new DataStreamSettings(this);
        }
    }
}

