/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.GetDataStreamResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetDataStreamRequest
extends RequestBase {
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean includeDefaults;
    @Nullable
    private final Time masterTimeout;
    private final List<String> name;
    @Nullable
    private final Boolean verbose;
    public static final Endpoint<GetDataStreamRequest, GetDataStreamResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetDataStreamRequest, GetDataStreamResponse>("es/indices.get_data_stream", request -> "GET", request -> {
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_data_stream");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _name = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (ApiTypeHelper.isDefined(request.expandWildcards)) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.jsonValue()).collect(Collectors.joining(",")));
        }
        if (request.includeDefaults != null) {
            params.put("include_defaults", String.valueOf(request.includeDefaults));
        }
        if (request.verbose != null) {
            params.put("verbose", String.valueOf(request.verbose));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetDataStreamResponse._DESERIALIZER);

    private GetDataStreamRequest(Builder builder) {
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.includeDefaults = builder.includeDefaults;
        this.masterTimeout = builder.masterTimeout;
        this.name = ApiTypeHelper.unmodifiable(builder.name);
        this.verbose = builder.verbose;
    }

    public static GetDataStreamRequest of(Function<Builder, ObjectBuilder<GetDataStreamRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean includeDefaults() {
        return this.includeDefaults;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    public final List<String> name() {
        return this.name;
    }

    @Nullable
    public final Boolean verbose() {
        return this.verbose;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetDataStreamRequest> {
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean includeDefaults;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private List<String> name;
        @Nullable
        private Boolean verbose;

        public Builder() {
        }

        private Builder(GetDataStreamRequest instance) {
            this.expandWildcards = instance.expandWildcards;
            this.includeDefaults = instance.includeDefaults;
            this.masterTimeout = instance.masterTimeout;
            this.name = instance.name;
            this.verbose = instance.verbose;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder includeDefaults(@Nullable Boolean value) {
            this.includeDefaults = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder verbose(@Nullable Boolean value) {
            this.verbose = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetDataStreamRequest build() {
            this._checkSingleUse();
            return new GetDataStreamRequest(this);
        }
    }
}

