/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FailureStoreLifecycle
implements JsonpSerializable {
    @Nullable
    private final Time dataRetention;
    @Nullable
    private final Boolean enabled;
    public static final JsonpDeserializer<FailureStoreLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FailureStoreLifecycle::setupFailureStoreLifecycleDeserializer);

    private FailureStoreLifecycle(Builder builder) {
        this.dataRetention = builder.dataRetention;
        this.enabled = builder.enabled;
    }

    public static FailureStoreLifecycle of(Function<Builder, ObjectBuilder<FailureStoreLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Time dataRetention() {
        return this.dataRetention;
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.dataRetention != null) {
            generator.writeKey("data_retention");
            this.dataRetention.serialize(generator, mapper);
        }
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFailureStoreLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dataRetention, Time._DESERIALIZER, "data_retention");
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FailureStoreLifecycle> {
        @Nullable
        private Time dataRetention;
        @Nullable
        private Boolean enabled;

        public Builder() {
        }

        private Builder(FailureStoreLifecycle instance) {
            this.dataRetention = instance.dataRetention;
            this.enabled = instance.enabled;
        }

        public final Builder dataRetention(@Nullable Time value) {
            this.dataRetention = value;
            return this;
        }

        public final Builder dataRetention(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.dataRetention(fn.apply(new Time.Builder()).build());
        }

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FailureStoreLifecycle build() {
            this._checkSingleUse();
            return new FailureStoreLifecycle(this);
        }
    }
}

