/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.indices.DownsampleConfig;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DownsamplingRound
implements JsonpSerializable {
    private final Time after;
    private final DownsampleConfig config;
    public static final JsonpDeserializer<DownsamplingRound> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DownsamplingRound::setupDownsamplingRoundDeserializer);

    private DownsamplingRound(Builder builder) {
        this.after = ApiTypeHelper.requireNonNull(builder.after, this, "after");
        this.config = ApiTypeHelper.requireNonNull(builder.config, this, "config");
    }

    public static DownsamplingRound of(Function<Builder, ObjectBuilder<DownsamplingRound>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Time after() {
        return this.after;
    }

    public final DownsampleConfig config() {
        return this.config;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("after");
        this.after.serialize(generator, mapper);
        generator.writeKey("config");
        this.config.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDownsamplingRoundDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::after, Time._DESERIALIZER, "after");
        op.add(Builder::config, DownsampleConfig._DESERIALIZER, "config");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DownsamplingRound> {
        private Time after;
        private DownsampleConfig config;

        public Builder() {
        }

        private Builder(DownsamplingRound instance) {
            this.after = instance.after;
            this.config = instance.config;
        }

        public final Builder after(Time value) {
            this.after = value;
            return this;
        }

        public final Builder after(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.after(fn.apply(new Time.Builder()).build());
        }

        public final Builder config(DownsampleConfig value) {
            this.config = value;
            return this;
        }

        public final Builder config(Function<DownsampleConfig.Builder, ObjectBuilder<DownsampleConfig>> fn) {
            return this.config(fn.apply(new DownsampleConfig.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DownsamplingRound build() {
            this._checkSingleUse();
            return new DownsamplingRound(this);
        }
    }
}

