/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch.indices.DataStreamFailureStoreTemplate;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DataStreamOptionsTemplate
implements JsonpSerializable {
    @Nullable
    private final DataStreamFailureStoreTemplate failureStore;
    public static final JsonpDeserializer<DataStreamOptionsTemplate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStreamOptionsTemplate::setupDataStreamOptionsTemplateDeserializer);

    private DataStreamOptionsTemplate(Builder builder) {
        this.failureStore = builder.failureStore;
    }

    public static DataStreamOptionsTemplate of(Function<Builder, ObjectBuilder<DataStreamOptionsTemplate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final DataStreamFailureStoreTemplate failureStore() {
        return this.failureStore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.failureStore != null) {
            generator.writeKey("failure_store");
            this.failureStore.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDataStreamOptionsTemplateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failureStore, DataStreamFailureStoreTemplate._DESERIALIZER, "failure_store");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataStreamOptionsTemplate> {
        @Nullable
        private DataStreamFailureStoreTemplate failureStore;

        public Builder() {
        }

        private Builder(DataStreamOptionsTemplate instance) {
            this.failureStore = instance.failureStore;
        }

        public final Builder failureStore(@Nullable DataStreamFailureStoreTemplate value) {
            this.failureStore = value;
            return this;
        }

        public final Builder failureStore(Function<DataStreamFailureStoreTemplate.Builder, ObjectBuilder<DataStreamFailureStoreTemplate>> fn) {
            return this.failureStore(fn.apply(new DataStreamFailureStoreTemplate.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataStreamOptionsTemplate build() {
            this._checkSingleUse();
            return new DataStreamOptionsTemplate(this);
        }
    }
}

