/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.analysis.CharFilter;
import co.elastic.clients.elasticsearch._types.analysis.TokenFilter;
import co.elastic.clients.elasticsearch._types.analysis.Tokenizer;
import co.elastic.clients.elasticsearch.indices.AnalyzeResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AnalyzeRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String analyzer;
    private final List<String> attributes;
    private final List<CharFilter> charFilter;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String field;
    private final List<TokenFilter> filter;
    @Nullable
    private final String index;
    @Nullable
    private final String normalizer;
    private final List<String> text;
    @Nullable
    private final Tokenizer tokenizer;
    public static final JsonpDeserializer<AnalyzeRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeRequest::setupAnalyzeRequestDeserializer);
    public static final Endpoint<AnalyzeRequest, AnalyzeResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AnalyzeRequest, AnalyzeResponse>("es/indices.analyze", request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_analyze");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_analyze");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, AnalyzeResponse._DESERIALIZER);

    private AnalyzeRequest(Builder builder) {
        this.analyzer = builder.analyzer;
        this.attributes = ApiTypeHelper.unmodifiable(builder.attributes);
        this.charFilter = ApiTypeHelper.unmodifiable(builder.charFilter);
        this.explain = builder.explain;
        this.field = builder.field;
        this.filter = ApiTypeHelper.unmodifiable(builder.filter);
        this.index = builder.index;
        this.normalizer = builder.normalizer;
        this.text = ApiTypeHelper.unmodifiable(builder.text);
        this.tokenizer = builder.tokenizer;
    }

    public static AnalyzeRequest of(Function<Builder, ObjectBuilder<AnalyzeRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String analyzer() {
        return this.analyzer;
    }

    public final List<String> attributes() {
        return this.attributes;
    }

    public final List<CharFilter> charFilter() {
        return this.charFilter;
    }

    @Nullable
    public final Boolean explain() {
        return this.explain;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    public final List<TokenFilter> filter() {
        return this.filter;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final String normalizer() {
        return this.normalizer;
    }

    public final List<String> text() {
        return this.text;
    }

    @Nullable
    public final Tokenizer tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            generator.write(this.analyzer);
        }
        if (ApiTypeHelper.isDefined(this.attributes)) {
            generator.writeKey("attributes");
            generator.writeStartArray();
            for (String string : this.attributes) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.charFilter)) {
            generator.writeKey("char_filter");
            generator.writeStartArray();
            for (CharFilter charFilter : this.charFilter) {
                charFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.explain != null) {
            generator.writeKey("explain");
            generator.write(this.explain.booleanValue());
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (ApiTypeHelper.isDefined(this.filter)) {
            generator.writeKey("filter");
            generator.writeStartArray();
            for (TokenFilter tokenFilter : this.filter) {
                tokenFilter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.normalizer != null) {
            generator.writeKey("normalizer");
            generator.write(this.normalizer);
        }
        if (ApiTypeHelper.isDefined(this.text)) {
            generator.writeKey("text");
            generator.writeStartArray();
            for (String string : this.text) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAnalyzeRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, JsonpDeserializer.stringDeserializer(), "analyzer");
        op.add(Builder::attributes, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "attributes");
        op.add(Builder::charFilter, JsonpDeserializer.arrayDeserializer(CharFilter._DESERIALIZER), "char_filter");
        op.add(Builder::explain, JsonpDeserializer.booleanDeserializer(), "explain");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::filter, JsonpDeserializer.arrayDeserializer(TokenFilter._DESERIALIZER), "filter");
        op.add(Builder::normalizer, JsonpDeserializer.stringDeserializer(), "normalizer");
        op.add(Builder::text, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "text");
        op.add(Builder::tokenizer, Tokenizer._DESERIALIZER, "tokenizer");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AnalyzeRequest> {
        @Nullable
        private String analyzer;
        @Nullable
        private List<String> attributes;
        @Nullable
        private List<CharFilter> charFilter;
        @Nullable
        private Boolean explain;
        @Nullable
        private String field;
        @Nullable
        private List<TokenFilter> filter;
        @Nullable
        private String index;
        @Nullable
        private String normalizer;
        @Nullable
        private List<String> text;
        @Nullable
        private Tokenizer tokenizer;

        public Builder() {
        }

        private Builder(AnalyzeRequest instance) {
            this.analyzer = instance.analyzer;
            this.attributes = instance.attributes;
            this.charFilter = instance.charFilter;
            this.explain = instance.explain;
            this.field = instance.field;
            this.filter = instance.filter;
            this.index = instance.index;
            this.normalizer = instance.normalizer;
            this.text = instance.text;
            this.tokenizer = instance.tokenizer;
        }

        public final Builder analyzer(@Nullable String value) {
            this.analyzer = value;
            return this;
        }

        public final Builder attributes(List<String> list) {
            this.attributes = Builder._listAddAll(this.attributes, list);
            return this;
        }

        public final Builder attributes(String value, String ... values) {
            this.attributes = Builder._listAdd(this.attributes, value, values);
            return this;
        }

        public final Builder charFilter(List<CharFilter> list) {
            this.charFilter = Builder._listAddAll(this.charFilter, list);
            return this;
        }

        public final Builder charFilter(CharFilter value, CharFilter ... values) {
            this.charFilter = Builder._listAdd(this.charFilter, value, values);
            return this;
        }

        public final Builder charFilter(Function<CharFilter.Builder, ObjectBuilder<CharFilter>> fn) {
            return this.charFilter(fn.apply(new CharFilter.Builder()).build(), new CharFilter[0]);
        }

        public final Builder explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        public final Builder filter(List<TokenFilter> list) {
            this.filter = Builder._listAddAll(this.filter, list);
            return this;
        }

        public final Builder filter(TokenFilter value, TokenFilter ... values) {
            this.filter = Builder._listAdd(this.filter, value, values);
            return this;
        }

        public final Builder filter(Function<TokenFilter.Builder, ObjectBuilder<TokenFilter>> fn) {
            return this.filter(fn.apply(new TokenFilter.Builder()).build(), new TokenFilter[0]);
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder normalizer(@Nullable String value) {
            this.normalizer = value;
            return this;
        }

        public final Builder text(List<String> list) {
            this.text = Builder._listAddAll(this.text, list);
            return this;
        }

        public final Builder text(String value, String ... values) {
            this.text = Builder._listAdd(this.text, value, values);
            return this;
        }

        public final Builder tokenizer(@Nullable Tokenizer value) {
            this.tokenizer = value;
            return this;
        }

        public final Builder tokenizer(Function<Tokenizer.Builder, ObjectBuilder<Tokenizer>> fn) {
            return this.tokenizer(fn.apply(new Tokenizer.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AnalyzeRequest build() {
            this._checkSingleUse();
            return new AnalyzeRequest(this);
        }
    }
}

