/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm;

import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.ilm.Actions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Phase
implements JsonpSerializable {
    @Nullable
    private final Actions actions;
    @Nullable
    private final Time minAge;
    public static final JsonpDeserializer<Phase> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Phase::setupPhaseDeserializer);

    private Phase(Builder builder) {
        this.actions = builder.actions;
        this.minAge = builder.minAge;
    }

    public static Phase of(Function<Builder, ObjectBuilder<Phase>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Actions actions() {
        return this.actions;
    }

    @Nullable
    public final Time minAge() {
        return this.minAge;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actions != null) {
            generator.writeKey("actions");
            this.actions.serialize(generator, mapper);
        }
        if (this.minAge != null) {
            generator.writeKey("min_age");
            this.minAge.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPhaseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, Actions._DESERIALIZER, "actions");
        op.add(Builder::minAge, Time._DESERIALIZER, "min_age");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Phase> {
        @Nullable
        private Actions actions;
        @Nullable
        private Time minAge;

        public Builder() {
        }

        private Builder(Phase instance) {
            this.actions = instance.actions;
            this.minAge = instance.minAge;
        }

        public final Builder actions(@Nullable Actions value) {
            this.actions = value;
            return this;
        }

        public final Builder actions(Function<Actions.Builder, ObjectBuilder<Actions>> fn) {
            return this.actions(fn.apply(new Actions.Builder()).build());
        }

        public final Builder minAge(@Nullable Time value) {
            this.minAge = value;
            return this;
        }

        public final Builder minAge(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.minAge(fn.apply(new Time.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Phase build() {
            this._checkSingleUse();
            return new Phase(this);
        }
    }
}

